#!/bin/bash

if [ $# -eq 0 ]; then
    echo "usage: $0 <folded.file>"
    exit 1
fi

cat $1			    |
sort -r -n -k2		       |
awk -F ' ' '{ print $1 }'   |
sed -e 's/full_cms`//g' -e 's/libc.so.1`//g' -e 's/libm.so.2`//g'       |
tee folded.before.awk |
awk '
BEGIN {
    print "#!/usr/sbin/dtrace -s"
    print "pid$target::*DoEventLoop*:entry  { initialized = 1; }"
    print "pid$target::*DoEventLoop*:return { initialized = 0; }"
}
BEGIN { FS = "," }
{
    for (i = 1; i <= NF; i++) {
	a[$i]++
    }
}
END {
cnt = 0
    for (i in a) {
cnt = cnt + 1
if (cnt < 50) {
	len = length(i);
	M = 100
	if (len > 120) {
		s = "*"  substr(i, len/2-M/2,M)  "*"
	} else {
	    s = i
	}
	printf "pid$target::%s:entry\n/initialized/\n{\n\tts[probefunc] = vtimestamp;\n}\n", s
        printf "pid$target::%s:return\n/initialized && ts[probefunc]/\n{\n\t@[probefunc] = avg( (vtimestamp - ts[probefunc])/1000000000 );\n\tts[probefunc] = 0;\n}\n", s
}
    }
}'
