#!/bin/bash

set -e
#set -x

pics='BU_cpu_clk_unhalted'                      # cycles
pics=$pics,'FR_retired_x86_instr_w_excp_intr'   # instructions

/usr/bin/cputrack -tc $pics -T 1 "$@" |
    awk 'BEGIN {
	printf "%16s %8s %8s\n", "Instructions", "CPI", "%CPU";
	skipped = 0
    }
    NR != 1 {			# skip first line (header)
	total  = $4 + 0		# to force arithmetic context
	cycles = $5 + 0
	instrs = $6 + 0

	if (total != 0 && cycles != 0 && instrs != 0) {
	    printf "%16u %8.2f %8.2f\n",
		instrs,
		instrs ?       cycles / instrs : 0,
		total  ? 100 * cycles / total  : 0
	}
    }
    END {
	printf "skipped =%d\n", skipped
    }'
