/* Automatically generated by 'BUILD_ERRORS' */

#include "gen-errors.h"
#include "error.h"
#include "ostream.h"


static ETagDataT ET[] = {
    UB "option" UE,
    UB "usage" UE,
    UB "option location" UE,
    UB "basic name" UE,
    UB "action name" UE,
    UB "type name" UE,
    UB "file name" UE,
    UB "line number" UE,
    UB "identifier name" UE,
    UB "character" UE,
    UB "builtin" UE,
    UB "class name" UE,
    UB "prefix" UE,
    UB "parameter type" UE,
    UB "correct type" UE,
    UB "erroneous type" UE,
    UB "result type" UE,
    UB "terminal name" UE,
    UB "builtin name" UE,
    UB "string name" UE,
    UB "error name" UE,
    UB "message" UE,
    UB "system error" UE,
    UB "except name" UE,
    UB "assertion" UE,
    UB "block address" UE,
    UB "allocation file name" UE,
    UB "allocation line number" UE,
    UB "rule name" UE,
    UB "non local name name" UE,
    UB "tab width" UE,
    UB "factor limit" UE,
    UB "phase" UE,
    UB "language name" UE,
    UB "split size" UE,
    UB "number input files" UE,
    UB "number output files" UE,
    UB "name name" UE,
    UB "correct ref type" UE,
    UB "alternative" UE,
    UB "production" UE,
    UB "terminal names" UE,
    UB "predicate name" UE,
    UB "predicate names" UE,
    UB "clashes" UE,
    UB "number productions" UE,
    UB "inner rule name" UE,
    UB "outer rule name" UE,
    UB "inner production" UE,
    UB "outer production" UE,
    UB "predicate" UE,
    UB "productions" UE,
    UB "rule names" UE,
    UB "using production" UE,
    UB "using rule name" UE,
    UB "out of scope production" UE,
    UB "out of scope rule name" UE,
    ERROR_END_TAG_LIST
};

static ErrorDataT EE[] = {
    UB {
	"arg parse unknown option",
	ERROR_SEVERITY_FATAL,
	"unknown option '${option}'\n\
${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"arg parse unknown short opt",
	ERROR_SEVERITY_FATAL,
	"unknown short option '${option}' at '${option location}'\n\
${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"arg parse ambiguous option",
	ERROR_SEVERITY_FATAL,
	"ambiguous option '${option}'\n\
${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"arg parse missing argument",
	ERROR_SEVERITY_FATAL,
	"missing argument for option '${option}'\n\
${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"arg parse missing short arg",
	ERROR_SEVERITY_FATAL,
	"missing argument for option '${option}' at '${option location}'\n\
${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"basic result code not defined",
	ERROR_SEVERITY_ERROR,
	"result code not defined for basic '${basic name}'",
	NIL(GenericP)
    } UE,
    UB {
	"action code not defined",
	ERROR_SEVERITY_ERROR,
	"definition code not defined for action '${action name}'",
	NIL(GenericP)
    } UE,
    UB {
	"type code not defined",
	ERROR_SEVERITY_ERROR,
	"some but not all assignment operations defined for type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"bad id substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted identifier '${identifier name}' is not a parameter or result",
	NIL(GenericP)
    } UE,
    UB {
	"bad mod id substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted mutable identifier '${identifier name}' is not a parameter",
	NIL(GenericP)
    } UE,
    UB {
	"mod id in assign",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted mutable identifier '${identifier name}' in assignment operator definition",
	NIL(GenericP)
    } UE,
    UB {
	"bad ref id substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted reference identifier '${identifier name}' is not a parameter",
	NIL(GenericP)
    } UE,
    UB {
	"ref id in param op",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted address of identifier '${identifier name}' in parameter assignment operator definition",
	NIL(GenericP)
    } UE,
    UB {
	"bad label substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted label '${identifier name}' in unparameterised block",
	NIL(GenericP)
    } UE,
    UB {
	"bad exception substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted exception call in unsuitable code block",
	NIL(GenericP)
    } UE,
    UB {
	"bad advance substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted lexer advance call in unsuitable code block",
	NIL(GenericP)
    } UE,
    UB {
	"bad terminal substitution",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: substituted current terminal call in unsuitable code block",
	NIL(GenericP)
    } UE,
    UB {
	"code undefined result",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: code result '${identifier name}' is not defined",
	NIL(GenericP)
    } UE,
    UB {
	"c illegal character",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: illegal character '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"c illegal comment character",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: illegal comment character '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"c eof in comment",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: end of file in comment",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unknown builtin '%${builtin}%'",
	NIL(GenericP)
    } UE,
    UB {
	"c null character in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: null character in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"c eof in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: end of file in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"c newline in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: newline in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"c code block syntax",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '{' to begin code block",
	NIL(GenericP)
    } UE,
    UB {
	"c illegal at char",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: illegal character after '@': '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"c eof in code",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: end of file in C code block",
	NIL(GenericP)
    } UE,
    UB {
	"c expected at id",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier after '@${character}' construct",
	NIL(GenericP)
    } UE,
    UB {
	"c expected basic",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected basic '${class name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected non-terminal",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected non-terminal '${class name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown prefix",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: unknown prefix type '${prefix}'",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown identifier",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: unknown identifier '${identifier name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c remapped identifier",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: attempt to remap identifier '${identifier name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c illegal map",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: cannot map identifier '${identifier name}' [it must be a rule, a basic or a type]",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown type",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: type '${type name}' hasn't been declared",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown assign",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: assignment operation defined for unknown type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c assign mult def",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: multiple assignment operations defined for type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c assign param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: assignment operation parameter clash (or missing name) for type '${type name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c assign param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c assign result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: assignment operation result clash (or missing name) for type '${type name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c assign result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c assign formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: assignment operation formal clash for type '${type name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown param assign",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter assignment operation defined for unknown type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign mult def",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: multiple parameter assignment operations defined for type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter assignment operation parameter clash (or missing name) for type '${type name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for parameter assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter assignment operation result clash (or missing name) for type '${type name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign res mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for parameter assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c param assign formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter assignment operation formal clash for type '${type name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown result assign",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result assignment operation defined for unknown type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c result assign mult def",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: multiple result assignment operations defined for type '${type name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c result assign param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result assignment operation parameter clash (or missing name) for type '${type name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c res assign param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for result assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c result assign result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result assignment operation result clash (or missing name) for type '${type name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c res assign result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for result assignment operation on type '${type name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c result assign formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result assignment operation formal clash for type '${type name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: definition for unknown action '${action name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c action mult def",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: multiple definitions for action '${action name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c action param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter clash (or missing name) for action '${action name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c action param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c action result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result clash (or missing name) for action '${action name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c action result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c action formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: formal clash for action '${action name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c unknown basic",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: extraction operation defined for unknown terminal '${terminal name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c basic mult def",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: multiple extraction operations defined for terminal '${terminal name}'",
	NIL(GenericP)
    } UE,
    UB {
	"c basic param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: extraction operation parameter clash (or missing name) for terminal '${terminal name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c basic param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for extraction operation on terminal '${terminal name}' [${erroneous type} should be ()]",
	NIL(GenericP)
    } UE,
    UB {
	"c basic result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: extraction operation result clash (or missing name) for terminal '${terminal name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c basic result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for extraction operation on terminal '${terminal name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c basic formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: extraction operation formal clash for terminal '${terminal name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"c basic has no result",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: extraction operation defined for terminal '${terminal name}' that returns nothing",
	NIL(GenericP)
    } UE,
    UB {
	"c expected identifier",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier",
	NIL(GenericP)
    } UE,
    UB {
	"c expected c identifier",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected C identifier",
	NIL(GenericP)
    } UE,
    UB {
	"c expected separator",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ','",
	NIL(GenericP)
    } UE,
    UB {
	"c expected open tuple",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '('",
	NIL(GenericP)
    } UE,
    UB {
	"c expected close tuple",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ')'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected arrow",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '->'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected terminator",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ';'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected end action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '>'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected define",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '='",
	NIL(GenericP)
    } UE,
    UB {
	"c expected code",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected code block",
	NIL(GenericP)
    } UE,
    UB {
	"c expected blt header",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%header%'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected blt terminals",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%terminals%'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected blt actions",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%actions%'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected blt trailer",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%trailer%'",
	NIL(GenericP)
    } UE,
    UB {
	"c expected eof",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected end of file",
	NIL(GenericP)
    } UE,
    UB {
	"errf null char in builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: null character in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"errf null character in name",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: null character in name",
	NIL(GenericP)
    } UE,
    UB {
	"errf null character in string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: null character in string",
	NIL(GenericP)
    } UE,
    UB {
	"errf newline in builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unescaped newline in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"errf newline in name",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unescaped newline in name",
	NIL(GenericP)
    } UE,
    UB {
	"errf newline in string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unescaped newline in string",
	NIL(GenericP)
    } UE,
    UB {
	"errf eof in builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unexpected end of file in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"errf eof in name",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unexpected end of file in name",
	NIL(GenericP)
    } UE,
    UB {
	"errf eof in string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unexpected end of file in string",
	NIL(GenericP)
    } UE,
    UB {
	"errf illegal esc in builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: illegal escape sequence in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"errf illegal escape in name",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: illegal escape sequence in name",
	NIL(GenericP)
    } UE,
    UB {
	"errf illegal escape in string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: illegal escape sequence in string",
	NIL(GenericP)
    } UE,
    UB {
	"errf unknown builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unknown builtin '%${builtin name}%'",
	NIL(GenericP)
    } UE,
    UB {
	"errf illegal character",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: illegal character '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"errf expected string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected string",
	NIL(GenericP)
    } UE,
    UB {
	"errf expected section",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected name or section header (one of '%strings%', '%prefix%' or '%errors%')",
	NIL(GenericP)
    } UE,
    UB {
	"errf unknown string",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unknown string name '${string name}'",
	NIL(GenericP)
    } UE,
    UB {
	"errf unknown error",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unknown error name '${error name}'",
	NIL(GenericP)
    } UE,
    UB {
	"errf illegal message",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: malformed or unterminated tag in message '${message}'",
	NIL(GenericP)
    } UE,
    UB {
	"errf cannot open",
	ERROR_SEVERITY_FATAL,
	"cannot open error file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"exception unhandled",
	ERROR_SEVERITY_INTERNAL,
	"unhandled exception '${except name}' thrown from line ${line number}, file '${file name}'",
	NIL(GenericP)
    } UE,
    UB {
	"exception corrupt handler",
	ERROR_SEVERITY_INTERNAL,
	"corrupt exception handler installed at line ${line number}, file '${file name}'",
	NIL(GenericP)
    } UE,
    UB {
	"assertion failed",
	ERROR_SEVERITY_INTERNAL,
	"assertion '${assertion}' failed at line ${line number}, file '${file name}'",
	NIL(GenericP)
    } UE,
    UB {
	"dalloc multi deallocate",
	ERROR_SEVERITY_INTERNAL,
	"memory block ${block address} allocated at line ${allocation line number} in '${allocation file name}' is deallocated more than once (second deallocation at line ${line number} in file '${file name}'",
	NIL(GenericP)
    } UE,
    UB {
	"dalloc corrupt block",
	ERROR_SEVERITY_INTERNAL,
	"memory block ${block address} is corrupt at deallocation (deallocation at line ${line number} in file '${file name}'",
	NIL(GenericP)
    } UE,
    UB {
	"rule not used",
	ERROR_SEVERITY_ERROR,
	"rule '${rule name}' is never used",
	NIL(GenericP)
    } UE,
    UB {
	"basic not used",
	ERROR_SEVERITY_ERROR,
	"basic '${basic name}' is never used",
	NIL(GenericP)
    } UE,
    UB {
	"action not used",
	ERROR_SEVERITY_ERROR,
	"action '${action name}' is never used",
	NIL(GenericP)
    } UE,
    UB {
	"type not used",
	ERROR_SEVERITY_ERROR,
	"type '${type name}' is never used",
	NIL(GenericP)
    } UE,
    UB {
	"non local not used",
	ERROR_SEVERITY_ERROR,
	"non local name '${non local name name}' is never used",
	NIL(GenericP)
    } UE,
    UB {
	"rule not defined",
	ERROR_SEVERITY_ERROR,
	"rule '${rule name}' is never defined",
	NIL(GenericP)
    } UE,
    UB {
	"too many terminals",
	ERROR_SEVERITY_FATAL,
	"too many terminals in grammar",
	NIL(GenericP)
    } UE,
    UB {
	"illegal character",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: illegal character '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"illegal comment character",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: illegal comment character '${character}'",
	NIL(GenericP)
    } UE,
    UB {
	"eof in comment",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: end of file in comment",
	NIL(GenericP)
    } UE,
    UB {
	"unknown builtin",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: unknown builtin '%${builtin}%'",
	NIL(GenericP)
    } UE,
    UB {
	"null character in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: null character in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"eof in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: end of file in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"newline in builtin",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: newline in builtin",
	NIL(GenericP)
    } UE,
    UB {
	"expected hash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: second character missing from '##' operator",
	NIL(GenericP)
    } UE,
    UB {
	"expected pipe",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: second character missing from '||' operator",
	NIL(GenericP)
    } UE,
    UB {
	"bad tab width",
	ERROR_SEVERITY_FATAL,
	"bad tab width '${tab width}'",
	NIL(GenericP)
    } UE,
    UB {
	"bad factor limit",
	ERROR_SEVERITY_FATAL,
	"bad factor limit '${factor limit}'",
	NIL(GenericP)
    } UE,
    UB {
	"bad inlining phase",
	ERROR_SEVERITY_FATAL,
	"bad inlining phase '${phase}'",
	NIL(GenericP)
    } UE,
    UB {
	"bad language",
	ERROR_SEVERITY_FATAL,
	"unknown language '${language name}' (should be 'ansi-c', 'pre-ansi-c', 'ossg-c' or 'test')",
	NIL(GenericP)
    } UE,
    UB {
	"bad language option",
	ERROR_SEVERITY_FATAL,
	"language '${language name}' doesn't understand option '${option}'",
	NIL(GenericP)
    } UE,
    UB {
	"bad split size",
	ERROR_SEVERITY_FATAL,
	"bad split size '${split size}'",
	NIL(GenericP)
    } UE,
    UB {
	"usage",
	ERROR_SEVERITY_FATAL,
	"language '${language name}' requires ${number input files} input files and ${number output files} output files\n${usage}",
	NIL(GenericP)
    } UE,
    UB {
	"cannot open dump file",
	ERROR_SEVERITY_FATAL,
	"cannot open dump file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"multiple dump files",
	ERROR_SEVERITY_FATAL,
	"more than one dump file specified",
	NIL(GenericP)
    } UE,
    UB {
	"cannot open output file",
	ERROR_SEVERITY_FATAL,
	"cannot open output file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"cannot open input file",
	ERROR_SEVERITY_FATAL,
	"cannot open input file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"no memory",
	ERROR_SEVERITY_FATAL,
	"cannot allocate memory",
	NIL(GenericP)
    } UE,
    UB {
	"read error",
	ERROR_SEVERITY_FATAL,
	"error reading from file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"write error",
	ERROR_SEVERITY_FATAL,
	"error writing to file '${file name}': ${system error}",
	NIL(GenericP)
    } UE,
    UB {
	"expected basic",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected terminal '${class name}'",
	NIL(GenericP)
    } UE,
    UB {
	"expected non-terminal",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: expected non-terminal '${class name}'",
	NIL(GenericP)
    } UE,
    UB {
	"duplicate action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' redeclared as action",
	NIL(GenericP)
    } UE,
    UB {
	"duplicate basic",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' redeclared as terminal",
	NIL(GenericP)
    } UE,
    UB {
	"duplicate rule",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' redeclared as rule",
	NIL(GenericP)
    } UE,
    UB {
	"duplicate type",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' redeclared as type",
	NIL(GenericP)
    } UE,
    UB {
	"duplicate non local",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' redeclared as non local",
	NIL(GenericP)
    } UE,
    UB {
	"unknown action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: action '${action name}' hasn't been declared",
	NIL(GenericP)
    } UE,
    UB {
	"unknown rule",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: rule '${rule name}' hasn't been declared or defined",
	NIL(GenericP)
    } UE,
    UB {
	"unknown type",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: type '${type name}' hasn't been declared",
	NIL(GenericP)
    } UE,
    UB {
	"unknown rule or basic",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' hasn't been declared or defined",
	NIL(GenericP)
    } UE,
    UB {
	"identity mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: type mismatch for identity [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"initialiser result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for initialiser of non local name '${name name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action result call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for invocation of action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic result call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for invocation of terminal '${terminal name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for invocation of rule '${rule name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"initialiser param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for initialiser of non local name '${name name}' [${erroneous type} should be ${correct type}, ${correct ref type} or ()]",
	NIL(GenericP)
    } UE,
    UB {
	"action param call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for invocation of action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic param call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for invocation of terminal '${terminal name}' [${erroneous type} should be ()])",
	NIL(GenericP)
    } UE,
    UB {
	"basic param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for declaration of terminal '${terminal name}' [${erroneous type} should be ()])",
	NIL(GenericP)
    } UE,
    UB {
	"rule param call mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for invocation of rule '${rule name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for production '${rule name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for production '${rule name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action param mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter type mismatch for action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result type mismatch for action '${action name}' [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"alt result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result formals are not defined in alternative ${alternative} of production '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"handler result mismatch",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result formals are not defined in exception handler alternative of production '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"multi predicate return",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result contains more than one predicate result symbol",
	NIL(GenericP)
    } UE,
    UB {
	"predicate type",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: predicate type mismatch [${erroneous type} should be ${correct type}]",
	NIL(GenericP)
    } UE,
    UB {
	"predicate",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: predicate result symbol used in result of something other than an action",
	NIL(GenericP)
    } UE,
    UB {
	"undefined assignment",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: assignment to undefined name '${name name}'",
	NIL(GenericP)
    } UE,
    UB {
	"rule already defined",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: production '${rule name}' is already defined",
	NIL(GenericP)
    } UE,
    UB {
	"rule formal clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter and result names are not disjoint for production '${rule name}' [parameter = ${parameter type}, result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule param clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter names are not disjoint (or are missing) for production '${rule name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result names are not disjoint (or are missing) for production '${rule name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"identity result clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result names are not disjoint for identity [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action result call clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result names are not disjoint for invocation of action '${action name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic result call clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result names are not disjoint for invocation of terminal '${terminal name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result call clash",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result names are not disjoint for invocation of rule '${rule name}' [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"undefined name",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: undefined parameter name '${identifier name}' in alternative ${alternative} of production '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"redefined name",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: redefined name '${identifier name}' in alternative ${alternative} of production '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"multiple empty alts",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: production '${rule name}' has multiple empty alternatives",
	NIL(GenericP)
    } UE,
    UB {
	"too many alternatives",
	ERROR_SEVERITY_FATAL,
	"${file name}: ${line number}: too many alternatives in grammar",
	NIL(GenericP)
    } UE,
    UB {
	"mult entry",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: rule '${rule name}' occurs in the entry list more than once",
	NIL(GenericP)
    } UE,
    UB {
	"rule param has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter of declaration of rule '${rule name}' has names [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration of rule '${rule name}' has names [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"rule result has refs",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration or definition of rule '${rule name}' has references [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action param has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter of declaration of action '${action name}' has names [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action result has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration of action '${action name}' has names [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"action result has refs",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration of action '${action name}' has references [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic param has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: parameter of declaration of terminal '${terminal name}' has names [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic result has names",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration of terminal '${terminal name}' has names [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"basic result has refs",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: result of declaration of terminal '${terminal name}' has references [result = ${result type}]",
	NIL(GenericP)
    } UE,
    UB {
	"identity param has refs",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: cannot take address of identity parameters in alternative ${alternative} of production '${rule name}' [parameter = ${parameter type}]",
	NIL(GenericP)
    } UE,
    UB {
	"ignored basic call",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: invocation of ignored terminal '${terminal name}'",
	NIL(GenericP)
    } UE,
    UB {
	"ambiguous call",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: identifier '${identifier name}' used in ambiguous context [may be name, rule or terminal]",
	NIL(GenericP)
    } UE,
    UB {
	"global scope non local",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: definition of non local name '${name name}' at global scope",
	NIL(GenericP)
    } UE,
    UB {
	"expected typemark",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ':'",
	NIL(GenericP)
    } UE,
    UB {
	"expected identifier",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier",
	NIL(GenericP)
    } UE,
    UB {
	"expected tuple defn",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier or ':'",
	NIL(GenericP)
    } UE,
    UB {
	"expected terminal decn",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier or '!'",
	NIL(GenericP)
    } UE,
    UB {
	"expected separator",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ','",
	NIL(GenericP)
    } UE,
    UB {
	"expected open tuple",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '('",
	NIL(GenericP)
    } UE,
    UB {
	"expected close tuple",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ')'",
	NIL(GenericP)
    } UE,
    UB {
	"expected arrow",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '->'",
	NIL(GenericP)
    } UE,
    UB {
	"expected terminator",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ';'",
	NIL(GenericP)
    } UE,
    UB {
	"expected lhs name",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier, '?' or '!'",
	NIL(GenericP)
    } UE,
    UB {
	"expected rhs name",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected identifier or '&'",
	NIL(GenericP)
    } UE,
    UB {
	"expected begin action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '<'",
	NIL(GenericP)
    } UE,
    UB {
	"expected end action",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '>'",
	NIL(GenericP)
    } UE,
    UB {
	"expected end scope",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ']'",
	NIL(GenericP)
    } UE,
    UB {
	"expected tuple or term",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected tuple or ';'",
	NIL(GenericP)
    } UE,
    UB {
	"expected item rhs",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected item right hand side",
	NIL(GenericP)
    } UE,
    UB {
	"expected define",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '='",
	NIL(GenericP)
    } UE,
    UB {
	"expected tuple def or term",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected tuple, '=' or ';'",
	NIL(GenericP)
    } UE,
    UB {
	"expected begin rule",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '{'",
	NIL(GenericP)
    } UE,
    UB {
	"expected end rule",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '}'",
	NIL(GenericP)
    } UE,
    UB {
	"expected item",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected item",
	NIL(GenericP)
    } UE,
    UB {
	"expected alternative",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected alternative",
	NIL(GenericP)
    } UE,
    UB {
	"expected other defn",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected rule declaration or rule or non local name definition",
	NIL(GenericP)
    } UE,
    UB {
	"expected production defn",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected rule declaration or definition, or action declaration",
	NIL(GenericP)
    } UE,
    UB {
	"expected blt types",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%types%'",
	NIL(GenericP)
    } UE,
    UB {
	"expected blt terminals",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%terminals%'",
	NIL(GenericP)
    } UE,
    UB {
	"expected blt productions",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%productions%'",
	NIL(GenericP)
    } UE,
    UB {
	"expected blt entry",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected '%entry%'",
	NIL(GenericP)
    } UE,
    UB {
	"expected eof",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected end of file",
	NIL(GenericP)
    } UE,
    UB {
	"expected terminator or define",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: expected ';' or '='",
	NIL(GenericP)
    } UE,
    UB {
	"first set collision",
	ERROR_SEVERITY_ERROR,
	"collision of terminal(s) ${terminal names} in rule '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"predicate collision",
	ERROR_SEVERITY_ERROR,
	"collision of predicate '${predicate name}' in rule '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"predicate list collision",
	ERROR_SEVERITY_ERROR,
	"collision of predicates ${predicate names} in rule '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"follow set collision",
	ERROR_SEVERITY_ERROR,
	"the terminal(s) ${terminal names} can start rule '${rule name}' which is see through, and the same terminal(s) may appear in the following situations:\n${clashes}",
	NIL(GenericP)
    } UE,
    UB {
	"predicate follow set coll",
	ERROR_SEVERITY_ERROR,
	"the predicate(s) ${predicate names} can start rule '${rule name}' which is see through, and the same predicate(s) may appear in the following situations:${clashes}",
	NIL(GenericP)
    } UE,
    UB {
	"multiple see through alts",
	ERROR_SEVERITY_ERROR,
	"the rule '${rule name}' contains more than one see through alternative",
	NIL(GenericP)
    } UE,
    UB {
	"too many factorisations",
	ERROR_SEVERITY_FATAL,
	"too many productions (${number productions}) created during factorisation",
	NIL(GenericP)
    } UE,
    UB {
	"factor handler mismatch",
	ERROR_SEVERITY_ERROR,
	"the rule '${inner rule name}' cannot be expanded into '${outer rule name}' as the exception handlers don't match",
	NIL(GenericP)
    } UE,
    UB {
	"factor nl entry",
	ERROR_SEVERITY_ERROR,
	"the rule '${inner rule name}' cannot be expanded into '${outer rule name}' as it contains non local name definitions",
	NIL(GenericP)
    } UE,
    UB {
	"cannot compute first set",
	ERROR_SEVERITY_ERROR,
	"cannot compute first set for production\n${production}",
	NIL(GenericP)
    } UE,
    UB {
	"see to predicate",
	ERROR_SEVERITY_ERROR,
	"can see through to predicate '${predicate}' in production\n${production}",
	NIL(GenericP)
    } UE,
    UB {
	"see to rule predicate",
	ERROR_SEVERITY_ERROR,
	"can see through to predicates in rule '${inner rule name}' in production\n${outer production}",
	NIL(GenericP)
    } UE,
    UB {
	"redundant see through alt",
	ERROR_SEVERITY_ERROR,
	"the rule '${rule name}' has all terminals in its first set and has a redundant see through alternative",
	NIL(GenericP)
    } UE,
    UB {
	"left recursion type mismatch",
	ERROR_SEVERITY_ERROR,
	"the parameter or result types of the left recursive calls in the following productions do not match:\n${productions}",
	NIL(GenericP)
    } UE,
    UB {
	"left rec handler mismatch",
	ERROR_SEVERITY_ERROR,
	"the exception handlers in the left recursion involving the following productions do not match:\n${productions}",
	NIL(GenericP)
    } UE,
    UB {
	"left recursion name mismatch",
	ERROR_SEVERITY_ERROR,
	"the argument names of the left recursive calls in the following productions do not match:\n${productions}",
	NIL(GenericP)
    } UE,
    UB {
	"out of scope non local",
	ERROR_SEVERITY_ERROR,
	"a non local name in the rule '${using rule name}' is not in scope in the rule '${out of scope rule name}' in the left recursive cycle involving the following productions:\n${productions}",
	NIL(GenericP)
    } UE,
    UB {
	"left recursion nl entry",
	ERROR_SEVERITY_ERROR,
	"the rule '${rule name}' declares non local names in the left recursive cycle with more than one entry point involving the following productions:\n${productions}",
	NIL(GenericP)
    } UE,
    UB {
	"cycle no terminator",
	ERROR_SEVERITY_ERROR,
	"no cycle termination for the left recursive set involving the following rules: ${rule names}",
	NIL(GenericP)
    } UE,
    UB {
	"shadows non local",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: the name '${name name}' shadows the non local name '${non local name name}' in rule '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"shadows global",
	ERROR_SEVERITY_ERROR,
	"${file name}: ${line number}: the name '${name name}' shadows a global name in rule '${rule name}'",
	NIL(GenericP)
    } UE,
    UB {
	"too many generated ids",
	ERROR_SEVERITY_FATAL,
	"too many automatically generated identifiers required",
	NIL(GenericP)
    } UE,
    UB {
	"too many generated names",
	ERROR_SEVERITY_FATAL,
	"too many automatically generated names required",
	NIL(GenericP)
    } UE,
    ERROR_END_ERROR_LIST
};

struct ES_00000 {
    CStringP                  option;
    ArgUsageP                 usage;
};
struct ES_00001 {
    CStringP                  option;
    CStringP                  option_location;
    ArgUsageP                 usage;
};
struct ES_00002 {
    KeyP                      basic_name;
};
struct ES_00003 {
    KeyP                      action_name;
};
struct ES_00004 {
    KeyP                      type_name;
};
struct ES_00005 {
    CStringP                  file_name;
    unsigned                  line_number;
    EntryP                    identifier_name;
};
struct ES_00006 {
    CStringP                  file_name;
    unsigned                  line_number;
};
struct ES_00007 {
    CStringP                  file_name;
    unsigned                  line_number;
    char                      character;
};
struct ES_00008 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  builtin;
};
struct ES_00009 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  class_name;
};
struct ES_00010 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  prefix;
};
struct ES_00011 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  identifier_name;
};
struct ES_00012 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  type_name;
};
struct ES_00013 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      type_name;
    TypeTupleP                parameter_type;
};
struct ES_00014 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      type_name;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00015 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      type_name;
    TypeTupleP                result_type;
};
struct ES_00016 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      type_name;
    TypeTupleP                parameter_type;
    TypeTupleP                result_type;
};
struct ES_00017 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  action_name;
};
struct ES_00018 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      action_name;
    TypeTupleP                parameter_type;
};
struct ES_00019 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      action_name;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00020 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      action_name;
    TypeTupleP                result_type;
};
struct ES_00021 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      action_name;
    TypeTupleP                parameter_type;
    TypeTupleP                result_type;
};
struct ES_00022 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  terminal_name;
};
struct ES_00023 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      terminal_name;
    TypeTupleP                parameter_type;
};
struct ES_00024 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      terminal_name;
    TypeTupleP                erroneous_type;
};
struct ES_00025 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      terminal_name;
    TypeTupleP                result_type;
};
struct ES_00026 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      terminal_name;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00027 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      terminal_name;
    TypeTupleP                parameter_type;
    TypeTupleP                result_type;
};
struct ES_00028 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  builtin_name;
};
struct ES_00029 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  string_name;
};
struct ES_00030 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  error_name;
};
struct ES_00031 {
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  message;
};
struct ES_00032 {
    CStringP                  file_name;
    int                       system_error;
};
struct ES_00033 {
    ExceptionP                except_name;
    CStringP                  file_name;
    unsigned                  line_number;
};
struct ES_00034 {
    CStringP                  assertion;
    CStringP                  file_name;
    unsigned                  line_number;
};
struct ES_00035 {
    GenericP                  block_address;
    CStringP                  file_name;
    unsigned                  line_number;
    CStringP                  allocation_file_name;
    unsigned                  allocation_line_number;
};
struct ES_00036 {
    GenericP                  block_address;
    CStringP                  file_name;
    unsigned                  line_number;
};
struct ES_00037 {
    KeyP                      rule_name;
};
struct ES_00038 {
    KeyP                      non_local_name_name;
};
struct ES_00039 {
    CStringP                  tab_width;
};
struct ES_00040 {
    CStringP                  factor_limit;
};
struct ES_00041 {
    CStringP                  phase;
};
struct ES_00042 {
    CStringP                  language_name;
};
struct ES_00043 {
    CStringP                  language_name;
    CStringP                  option;
};
struct ES_00044 {
    CStringP                  split_size;
};
struct ES_00045 {
    CStringP                  language_name;
    unsigned                  number_input_files;
    unsigned                  number_output_files;
    ArgUsageP                 usage;
};
struct ES_00046 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  rule_name;
};
struct ES_00047 {
    CStringP                  file_name;
    unsigned                  line_number;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00048 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      name_name;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00049 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
    TypeTupleP                correct_type;
    TypeTupleP                erroneous_type;
};
struct ES_00050 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      name_name;
    TypeTupleP                correct_type;
    TypeTupleP                correct_ref_type;
    TypeTupleP                erroneous_type;
};
struct ES_00051 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
    unsigned                  alternative;
};
struct ES_00052 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
};
struct ES_00053 {
    CStringP                  file_name;
    unsigned                  line_number;
    EntryP                    correct_type;
    EntryP                    erroneous_type;
};
struct ES_00054 {
    CStringP                  file_name;
    unsigned                  line_number;
    NStringP                  name_name;
};
struct ES_00055 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
    TypeTupleP                parameter_type;
    TypeTupleP                result_type;
};
struct ES_00056 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
    TypeTupleP                parameter_type;
};
struct ES_00057 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      rule_name;
    TypeTupleP                result_type;
};
struct ES_00058 {
    CStringP                  file_name;
    unsigned                  line_number;
    TypeTupleP                result_type;
};
struct ES_00059 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      identifier_name;
    KeyP                      rule_name;
    unsigned                  alternative;
};
struct ES_00060 {
    CStringP                  file_name;
    unsigned                  line_number;
    TypeTupleP                parameter_type;
    KeyP                      rule_name;
    unsigned                  alternative;
};
struct ES_00061 {
    RuleP                     rule_name;
    RuleP                     production;
    BasicClosureP             terminal_names;
};
struct ES_00062 {
    RuleP                     rule_name;
    RuleP                     production;
    KeyP                      predicate_name;
};
struct ES_00063 {
    RuleP                     rule_name;
    RuleP                     production;
    EntryListP                predicate_names;
};
struct ES_00064 {
    RuleP                     rule_name;
    RuleP                     production;
    BasicClosureP             terminal_names;
    ClashListP                clashes;
};
struct ES_00065 {
    RuleP                     rule_name;
    RuleP                     production;
    EntryListP                predicate_names;
    ClashListP                clashes;
};
struct ES_00066 {
    RuleP                     rule_name;
    RuleP                     production;
};
struct ES_00067 {
    unsigned                  number_productions;
};
struct ES_00068 {
    RuleP                     inner_rule_name;
    RuleP                     outer_rule_name;
    RuleP                     inner_production;
    RuleP                     outer_production;
};
struct ES_00069 {
    RuleP                     production;
    RuleP                     rule_name;
};
struct ES_00070 {
    KeyP                      predicate;
    RuleP                     production;
    RuleP                     rule_name;
};
struct ES_00071 {
    RuleP                     inner_production;
    RuleP                     inner_rule_name;
    RuleP                     outer_production;
    RuleP                     outer_rule_name;
};
struct ES_00072 {
    RuleP                     productions;
    RuleP                     rule_names;
};
struct ES_00073 {
    RuleP                     using_production;
    RuleP                     using_rule_name;
    RuleP                     out_of_scope_production;
    RuleP                     out_of_scope_rule_name;
    RuleP                     productions;
    RuleP                     rule_names;
};
struct ES_00074 {
    RuleP                     production;
    RuleP                     rule_name;
    RuleP                     productions;
    RuleP                     rule_names;
};
struct ES_00075 {
    RuleP                     rule_names;
};
struct ES_00076 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      name_name;
    KeyP                      non_local_name_name;
    RuleP                     production;
    RuleP                     rule_name;
};
struct ES_00077 {
    CStringP                  file_name;
    unsigned                  line_number;
    KeyP                      name_name;
    RuleP                     production;
    RuleP                     rule_name;
};

static void
ET_00000(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00000 *closure = (struct ES_00000 *)gclosure;

    if (tag == ET[0].tag) {
	    write_cstring(ostream, closure->option);
    } else if (tag == ET[1].tag) {
	    write_arg_usage(ostream, closure->usage);
    }
}
static void
ET_00001(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00001 *closure = (struct ES_00001 *)gclosure;

    if (tag == ET[0].tag) {
	    write_cstring(ostream, closure->option);
    } else if (tag == ET[2].tag) {
	    write_cstring(ostream, closure->option_location);
    } else if (tag == ET[1].tag) {
	    write_arg_usage(ostream, closure->usage);
    }
}
static void
ET_00002(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00002 *closure = (struct ES_00002 *)gclosure;

    if (tag == ET[3].tag) {
	    write_key(ostream, closure->basic_name);
    }
}
static void
ET_00003(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00003 *closure = (struct ES_00003 *)gclosure;

    if (tag == ET[4].tag) {
	    write_key(ostream, closure->action_name);
    }
}
static void
ET_00004(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00004 *closure = (struct ES_00004 *)gclosure;

    if (tag == ET[5].tag) {
	    write_key(ostream, closure->type_name);
    }
}
static void
ET_00005(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00005 *closure = (struct ES_00005 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[8].tag) {
	    write_key(ostream, entry_key(closure->identifier_name));
    }
}
static void
ET_00006(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00006 *closure = (struct ES_00006 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    }
}
static void
ET_00007(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00007 *closure = (struct ES_00007 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[9].tag) {
	    write_escaped_char(ostream, closure->character);
    }
}
static void
ET_00008(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00008 *closure = (struct ES_00008 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[10].tag) {
	    write_cstring(ostream, closure->builtin);
    }
}
static void
ET_00009(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00007 *closure = (struct ES_00007 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[9].tag) {
	    write_char(ostream, closure->character);
    }
}
static void
ET_00010(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00009 *closure = (struct ES_00009 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[11].tag) {
	    write_cstring(ostream, closure->class_name);
    }
}
static void
ET_00011(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00010 *closure = (struct ES_00010 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[12].tag) {
	    write_nstring(ostream, closure->prefix);
    }
}
static void
ET_00012(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00011 *closure = (struct ES_00011 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[8].tag) {
	    write_nstring(ostream, closure->identifier_name);
    }
}
static void
ET_00013(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00012 *closure = (struct ES_00012 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[5].tag) {
	    write_nstring(ostream, closure->type_name);
    }
}
static void
ET_00014(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00013 *closure = (struct ES_00013 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[5].tag) {
	    write_key(ostream, closure->type_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    }
}
static void
ET_00015(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00014 *closure = (struct ES_00014 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[5].tag) {
	    write_key(ostream, closure->type_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00016(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00015 *closure = (struct ES_00015 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[5].tag) {
	    write_key(ostream, closure->type_name);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00017(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00016 *closure = (struct ES_00016 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[5].tag) {
	    write_key(ostream, closure->type_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00018(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00017 *closure = (struct ES_00017 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[4].tag) {
	    write_nstring(ostream, closure->action_name);
    }
}
static void
ET_00019(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00018 *closure = (struct ES_00018 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[4].tag) {
	    write_key(ostream, closure->action_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    }
}
static void
ET_00020(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00019 *closure = (struct ES_00019 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[4].tag) {
	    write_key(ostream, closure->action_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00021(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00020 *closure = (struct ES_00020 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[4].tag) {
	    write_key(ostream, closure->action_name);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00022(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00021 *closure = (struct ES_00021 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[4].tag) {
	    write_key(ostream, closure->action_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00023(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00022 *closure = (struct ES_00022 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_nstring(ostream, closure->terminal_name);
    }
}
static void
ET_00024(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00023 *closure = (struct ES_00023 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_key(ostream, closure->terminal_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    }
}
static void
ET_00025(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00024 *closure = (struct ES_00024 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_key(ostream, closure->terminal_name);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00026(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00025 *closure = (struct ES_00025 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_key(ostream, closure->terminal_name);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00027(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00026 *closure = (struct ES_00026 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_key(ostream, closure->terminal_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00028(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00027 *closure = (struct ES_00027 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[17].tag) {
	    write_key(ostream, closure->terminal_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00029(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00028 *closure = (struct ES_00028 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[18].tag) {
	    write_cstring(ostream, closure->builtin_name);
    }
}
static void
ET_00030(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00029 *closure = (struct ES_00029 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[19].tag) {
	    write_cstring(ostream, closure->string_name);
    }
}
static void
ET_00031(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00030 *closure = (struct ES_00030 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[20].tag) {
	    write_cstring(ostream, closure->error_name);
    }
}
static void
ET_00032(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00031 *closure = (struct ES_00031 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[21].tag) {
	    write_cstring(ostream, closure->message);
    }
}
static void
ET_00033(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00032 *closure = (struct ES_00032 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[22].tag) {
	    write_system_error(ostream);
    }
}
static void
ET_00034(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00033 *closure = (struct ES_00033 *)gclosure;

    if (tag == ET[23].tag) {
	    write_cstring(ostream, exception_name(closure->except_name));
    } else if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    }
}
static void
ET_00035(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00034 *closure = (struct ES_00034 *)gclosure;

    if (tag == ET[24].tag) {
	    write_cstring(ostream, closure->assertion);
    } else if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    }
}
static void
ET_00036(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00035 *closure = (struct ES_00035 *)gclosure;

    if (tag == ET[25].tag) {
	    write_pointer(ostream, closure->block_address);
    } else if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[26].tag) {
	    write_cstring(ostream, closure->allocation_file_name);
    } else if (tag == ET[27].tag) {
	    write_unsigned(ostream, closure->allocation_line_number);
    }
}
static void
ET_00037(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00036 *closure = (struct ES_00036 *)gclosure;

    if (tag == ET[25].tag) {
	    write_pointer(ostream, closure->block_address);
    } else if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    }
}
static void
ET_00038(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00037 *closure = (struct ES_00037 *)gclosure;

    if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    }
}
static void
ET_00039(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00038 *closure = (struct ES_00038 *)gclosure;

    if (tag == ET[29].tag) {
	    write_key(ostream, closure->non_local_name_name);
    }
}
static void
ET_00040(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    UNUSED(ostream);
    UNUSED(tag);
    UNUSED(gclosure);
}
static void
ET_00041(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00039 *closure = (struct ES_00039 *)gclosure;

    if (tag == ET[30].tag) {
	    write_cstring(ostream, closure->tab_width);
    }
}
static void
ET_00042(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00040 *closure = (struct ES_00040 *)gclosure;

    if (tag == ET[31].tag) {
	    write_cstring(ostream, closure->factor_limit);
    }
}
static void
ET_00043(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00041 *closure = (struct ES_00041 *)gclosure;

    if (tag == ET[32].tag) {
	    write_cstring(ostream, closure->phase);
    }
}
static void
ET_00044(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00042 *closure = (struct ES_00042 *)gclosure;

    if (tag == ET[33].tag) {
	    write_cstring(ostream, closure->language_name);
    }
}
static void
ET_00045(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00043 *closure = (struct ES_00043 *)gclosure;

    if (tag == ET[33].tag) {
	    write_cstring(ostream, closure->language_name);
    } else if (tag == ET[0].tag) {
	    write_cstring(ostream, closure->option);
    }
}
static void
ET_00046(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00044 *closure = (struct ES_00044 *)gclosure;

    if (tag == ET[34].tag) {
	    write_cstring(ostream, closure->split_size);
    }
}
static void
ET_00047(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00045 *closure = (struct ES_00045 *)gclosure;

    if (tag == ET[33].tag) {
	    write_cstring(ostream, closure->language_name);
    } else if (tag == ET[35].tag) {
	    write_unsigned(ostream, closure->number_input_files);
    } else if (tag == ET[36].tag) {
	    write_unsigned(ostream, closure->number_output_files);
    } else if (tag == ET[1].tag) {
	    write_arg_usage(ostream, closure->usage);
    }
}
static void
ET_00048(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00046 *closure = (struct ES_00046 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_nstring(ostream, closure->rule_name);
    }
}
static void
ET_00049(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00047 *closure = (struct ES_00047 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00050(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00048 *closure = (struct ES_00048 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[37].tag) {
	    write_key(ostream, closure->name_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00051(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00049 *closure = (struct ES_00049 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00052(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00050 *closure = (struct ES_00050 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[37].tag) {
	    write_key(ostream, closure->name_name);
    } else if (tag == ET[14].tag) {
	    write_type_types(ostream, closure->correct_type);
    } else if (tag == ET[38].tag) {
	    write_type_types(ostream, closure->correct_ref_type);
    } else if (tag == ET[15].tag) {
	    write_type_types(ostream, closure->erroneous_type);
    }
}
static void
ET_00053(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00051 *closure = (struct ES_00051 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[39].tag) {
	    write_unsigned(ostream, closure->alternative);
    }
}
static void
ET_00054(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00052 *closure = (struct ES_00052 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    }
}
static void
ET_00055(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00053 *closure = (struct ES_00053 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[14].tag) {
	    write_key(ostream, entry_key(closure->correct_type));
    } else if (tag == ET[15].tag) {
	    write_key(ostream, entry_key(closure->erroneous_type));
    }
}
static void
ET_00056(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00054 *closure = (struct ES_00054 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[37].tag) {
	    write_nstring(ostream, closure->name_name);
    }
}
static void
ET_00057(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00055 *closure = (struct ES_00055 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00058(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00056 *closure = (struct ES_00056 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    }
}
static void
ET_00059(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00057 *closure = (struct ES_00057 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00060(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00058 *closure = (struct ES_00058 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[16].tag) {
	    write_type_names(ostream, closure->result_type, FALSE);
    }
}
static void
ET_00061(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00059 *closure = (struct ES_00059 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[8].tag) {
	    write_key(ostream, closure->identifier_name);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[39].tag) {
	    write_unsigned(ostream, closure->alternative);
    }
}
static void
ET_00062(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00060 *closure = (struct ES_00060 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[13].tag) {
	    write_type_names(ostream, closure->parameter_type, FALSE);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, closure->rule_name);
    } else if (tag == ET[39].tag) {
	    write_unsigned(ostream, closure->alternative);
    }
}
static void
ET_00063(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00061 *closure = (struct ES_00061 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    } else if (tag == ET[41].tag) {
	    write_basics(ostream, closure->terminal_names);
    }
}
static void
ET_00064(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00062 *closure = (struct ES_00062 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    } else if (tag == ET[42].tag) {
	    write_key(ostream, closure->predicate_name);
    }
}
static void
ET_00065(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00063 *closure = (struct ES_00063 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    } else if (tag == ET[43].tag) {
	    write_entry_list(ostream, closure->predicate_names);
    }
}
static void
ET_00066(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00064 *closure = (struct ES_00064 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    } else if (tag == ET[41].tag) {
	    write_basics(ostream, closure->terminal_names);
    } else if (tag == ET[44].tag) {
	    write_clashes(ostream, closure->clashes);
    }
}
static void
ET_00067(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00065 *closure = (struct ES_00065 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    } else if (tag == ET[43].tag) {
	    write_entry_list(ostream, closure->predicate_names);
    } else if (tag == ET[44].tag) {
	    write_clashes(ostream, closure->clashes);
    }
}
static void
ET_00068(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00066 *closure = (struct ES_00066 *)gclosure;

    if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->rule_name);
    }
}
static void
ET_00069(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00067 *closure = (struct ES_00067 *)gclosure;

    if (tag == ET[45].tag) {
	    write_unsigned(ostream, closure->number_productions);
    }
}
static void
ET_00070(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00068 *closure = (struct ES_00068 *)gclosure;

    if (tag == ET[46].tag) {
	    EntryP entry = rule_entry(closure->inner_rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[47].tag) {
	    EntryP entry = rule_entry(closure->outer_rule_name);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[48].tag) {
	    write_rule(ostream, closure->inner_rule_name);
    } else if (tag == ET[49].tag) {
	    write_rule(ostream, closure->outer_rule_name);
    }
}
static void
ET_00071(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00069 *closure = (struct ES_00069 *)gclosure;

    if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, entry_key(rule_entry(closure->production)));
    }
}
static void
ET_00072(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00070 *closure = (struct ES_00070 *)gclosure;

    if (tag == ET[50].tag) {
	    write_key(ostream, closure->predicate);
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, entry_key(rule_entry(closure->production)));
    }
}
static void
ET_00073(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00071 *closure = (struct ES_00071 *)gclosure;

    if (tag == ET[48].tag) {
	    write_rule(ostream, closure->inner_production);
    } else if (tag == ET[46].tag) {
	    EntryP entry = rule_entry(closure->inner_production);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[49].tag) {
	    write_rule(ostream, closure->outer_production);
    } else if (tag == ET[47].tag) {
	    EntryP entry = rule_entry(closure->outer_production);

	    write_key(ostream, entry_key(entry));
    }
}
static void
ET_00074(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00069 *closure = (struct ES_00069 *)gclosure;

    if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->production);

	    write_key(ostream, entry_key(entry));
    }
}
static void
ET_00075(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00072 *closure = (struct ES_00072 *)gclosure;

    if (tag == ET[51].tag) {
	    RuleP rule = closure->productions;

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		write_newline(ostream);
		write_rule(ostream, rule);
	    }
    } else if (tag == ET[52].tag) {
	    RuleP    rule = closure->productions;
	    CStringP sep  = "";

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		RuleP next = rule_get_next_in_reverse_dfs(rule);

		write_cstring(ostream, sep);
		write_char(ostream, '\'');
		write_key(ostream, entry_key(rule_entry(rule)));
		write_char(ostream, '\'');
		if (next != NIL(RuleP)) {
		    if (rule_get_next_in_reverse_dfs(next)) {
			sep = ", ";
		    } else {
			sep = " & ";
		    }
		}
	    }
    }
}
static void
ET_00076(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00073 *closure = (struct ES_00073 *)gclosure;

    if (tag == ET[53].tag) {
	    write_rule(ostream, closure->using_production);
    } else if (tag == ET[54].tag) {
	    EntryP entry = rule_entry(closure->using_production);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[55].tag) {
	    write_rule(ostream, closure->out_of_scope_production);
    } else if (tag == ET[56].tag) {
	    EntryP entry = rule_entry(closure->out_of_scope_production);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[51].tag) {
	    RuleP rule = closure->productions;

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		write_newline(ostream);
		write_rule(ostream, rule);
	    }
    } else if (tag == ET[52].tag) {
	    RuleP    rule = closure->productions;
	    CStringP sep  = "";

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		RuleP next = rule_get_next_in_reverse_dfs(rule);

		write_cstring(ostream, sep);
		write_char(ostream, '\'');
		write_key(ostream, entry_key(rule_entry(rule)));
		write_char(ostream, '\'');
		if (next != NIL(RuleP)) {
		    if (rule_get_next_in_reverse_dfs(next)) {
			sep = ", ";
		    } else {
			sep = " & ";
		    }
		}
	    }
    }
}
static void
ET_00077(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00074 *closure = (struct ES_00074 *)gclosure;

    if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    EntryP entry = rule_entry(closure->production);

	    write_key(ostream, entry_key(entry));
    } else if (tag == ET[51].tag) {
	    RuleP rule = closure->productions;

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		write_newline(ostream);
		write_rule(ostream, rule);
	    }
    } else if (tag == ET[52].tag) {
	    RuleP    rule = closure->productions;
	    CStringP sep  = "";

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		RuleP next = rule_get_next_in_reverse_dfs(rule);

		write_cstring(ostream, sep);
		write_char(ostream, '\'');
		write_key(ostream, entry_key(rule_entry(rule)));
		write_char(ostream, '\'');
		if (next != NIL(RuleP)) {
		    if (rule_get_next_in_reverse_dfs(next)) {
			sep = ", ";
		    } else {
			sep = " & ";
		    }
		}
	    }
    }
}
static void
ET_00078(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00075 *closure = (struct ES_00075 *)gclosure;

    if (tag == ET[52].tag) {
	    RuleP    rule = closure->rule_names;
	    CStringP sep  = "";

	    for (; rule; rule = rule_get_next_in_reverse_dfs(rule)) {
		RuleP next = rule_get_next_in_reverse_dfs(rule);

		write_cstring(ostream, sep);
		write_char(ostream, '\'');
		write_key(ostream, entry_key(rule_entry(rule)));
		write_char(ostream, '\'');
		if (next != NIL(RuleP)) {
		    if (rule_get_next_in_reverse_dfs(next)) {
			sep = ", ";
		    } else {
			sep = " & ";
		    }
		}
	    }
    }
}
static void
ET_00079(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00076 *closure = (struct ES_00076 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[37].tag) {
	    write_key(ostream, closure->name_name);
    } else if (tag == ET[29].tag) {
	    write_key(ostream, closure->non_local_name_name);
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, entry_key(rule_entry(closure->production)));
    }
}
static void
ET_00080(OStreamP ostream, ETagP tag, GenericP gclosure)
{
    struct ES_00077 *closure = (struct ES_00077 *)gclosure;

    if (tag == ET[6].tag) {
	    write_cstring(ostream, closure->file_name);
    } else if (tag == ET[7].tag) {
	    write_unsigned(ostream, closure->line_number);
    } else if (tag == ET[37].tag) {
	    write_key(ostream, closure->name_name);
    } else if (tag == ET[40].tag) {
	    write_rule(ostream, closure->production);
    } else if (tag == ET[28].tag) {
	    write_key(ostream, entry_key(rule_entry(closure->production)));
    }
}

void
E_arg_parse_unknown_option(CStringP option,
                           ArgUsageP usage)
{
    struct ES_00000 closure;

    closure.option = option;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[0].error, ET_00000, (GenericP)&closure);
    UNREACHED;
}
void
E_arg_parse_unknown_short_opt(CStringP option,
                              CStringP option_location, ArgUsageP usage)
{
    struct ES_00001 closure;

    closure.option = option;
    closure.option_location = option_location;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[1].error, ET_00001, (GenericP)&closure);
    UNREACHED;
}
void
E_arg_parse_ambiguous_option(CStringP option,
                             ArgUsageP usage)
{
    struct ES_00000 closure;

    closure.option = option;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[2].error, ET_00000, (GenericP)&closure);
    UNREACHED;
}
void
E_arg_parse_missing_argument(CStringP option,
                             ArgUsageP usage)
{
    struct ES_00000 closure;

    closure.option = option;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[3].error, ET_00000, (GenericP)&closure);
    UNREACHED;
}
void
E_arg_parse_missing_short_arg(CStringP option,
                              CStringP option_location, ArgUsageP usage)
{
    struct ES_00001 closure;

    closure.option = option;
    closure.option_location = option_location;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[4].error, ET_00001, (GenericP)&closure);
    UNREACHED;
}
void
E_basic_result_code_not_defined(KeyP basic_name)
{
    struct ES_00002 closure;

    closure.basic_name = basic_name;
    error_call_init_proc();
    error_report(EE[5].error, ET_00002, (GenericP)&closure);
}
void
E_action_code_not_defined(KeyP action_name)
{
    struct ES_00003 closure;

    closure.action_name = action_name;
    error_call_init_proc();
    error_report(EE[6].error, ET_00003, (GenericP)&closure);
}
void
E_type_code_not_defined(KeyP type_name)
{
    struct ES_00004 closure;

    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[7].error, ET_00004, (GenericP)&closure);
}
void
E_bad_id_substitution(CStringP file_name,
                      unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[8].error, ET_00005, (GenericP)&closure);
}
void
E_bad_mod_id_substitution(CStringP file_name,
                          unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[9].error, ET_00005, (GenericP)&closure);
}
void
E_mod_id_in_assign(CStringP file_name,
                   unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[10].error, ET_00005, (GenericP)&closure);
}
void
E_bad_ref_id_substitution(CStringP file_name,
                          unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[11].error, ET_00005, (GenericP)&closure);
}
void
E_ref_id_in_param_op(CStringP file_name,
                     unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[12].error, ET_00005, (GenericP)&closure);
}
void
E_bad_label_substitution(CStringP file_name,
                         unsigned line_number, EntryP identifier_name)
{
    struct ES_00005 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[13].error, ET_00005, (GenericP)&closure);
}
void
E_bad_exception_substitution(CStringP file_name,
                             unsigned line_number)
{
    struct ES_00006 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[14].error, ET_00006, (GenericP)&closure);
}
void
E_bad_advance_substitution(CStringP file_name,
                           unsigned line_number)
{
    struct ES_00006 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[15].error, ET_00006, (GenericP)&closure);
}
void
E_bad_terminal_substitution(CStringP file_name,
                            unsigned line_number)
{
    struct ES_00006 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[16].error, ET_00006, (GenericP)&closure);
}
void
E_code_undefined_result(GenericP code,
                        EntryP identifier_name)
{
    struct ES_00005 closure;

	    closure.file_name = c_code_file((CCodeP)code);
	    closure.line_number = c_code_line((CCodeP)code);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[17].error, ET_00005, (GenericP)&closure);
}
void
E_c_illegal_character(IStreamP istream,
                      char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[18].error, ET_00007, (GenericP)&closure);
}
void
E_c_illegal_comment_character(IStreamP istream,
                              char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[19].error, ET_00007, (GenericP)&closure);
}
void
E_c_eof_in_comment(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[20].error, ET_00006, (GenericP)&closure);
}
void
E_c_unknown_builtin(IStreamP istream,
                    CStringP builtin)
{
    struct ES_00008 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.builtin = builtin;
    error_call_init_proc();
    error_report(EE[21].error, ET_00008, (GenericP)&closure);
    UNREACHED;
}
void
E_c_null_character_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[22].error, ET_00006, (GenericP)&closure);
}
void
E_c_eof_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[23].error, ET_00006, (GenericP)&closure);
}
void
E_c_newline_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[24].error, ET_00006, (GenericP)&closure);
}
void
E_c_code_block_syntax(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[25].error, ET_00006, (GenericP)&closure);
}
void
E_c_illegal_at_char(IStreamP istream,
                    char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[26].error, ET_00007, (GenericP)&closure);
}
void
E_c_eof_in_code(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[27].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_at_id(IStreamP istream,
                   char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[28].error, ET_00009, (GenericP)&closure);
}
void
E_c_expected_basic(CStringP class_name)
{
    struct ES_00009 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.class_name = class_name;
    error_call_init_proc();
    error_report(EE[29].error, ET_00010, (GenericP)&closure);
    UNREACHED;
}
void
E_c_expected_non_terminal(CStringP class_name)
{
    struct ES_00009 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.class_name = class_name;
    error_call_init_proc();
    error_report(EE[30].error, ET_00010, (GenericP)&closure);
    UNREACHED;
}
void
E_c_unknown_prefix(NStringP prefix)
{
    struct ES_00010 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.prefix = prefix;
    error_call_init_proc();
    error_report(EE[31].error, ET_00011, (GenericP)&closure);
}
void
E_c_unknown_identifier(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[32].error, ET_00012, (GenericP)&closure);
}
void
E_c_remapped_identifier(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[33].error, ET_00012, (GenericP)&closure);
}
void
E_c_illegal_map(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[34].error, ET_00012, (GenericP)&closure);
}
void
E_c_unknown_type(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[35].error, ET_00013, (GenericP)&closure);
}
void
E_c_unknown_assign(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[36].error, ET_00013, (GenericP)&closure);
}
void
E_c_assign_mult_def(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[37].error, ET_00013, (GenericP)&closure);
}
void
E_c_assign_param_clash(KeyP type_name,
                       TypeTupleP parameter_type)
{
    struct ES_00013 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[38].error, ET_00014, (GenericP)&closure);
}
void
E_c_assign_param_mismatch(KeyP type_name,
                          TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[39].error, ET_00015, (GenericP)&closure);
}
void
E_c_assign_result_clash(KeyP type_name,
                        TypeTupleP result_type)
{
    struct ES_00015 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[40].error, ET_00016, (GenericP)&closure);
}
void
E_c_assign_result_mismatch(KeyP type_name,
                           TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[41].error, ET_00015, (GenericP)&closure);
}
void
E_c_assign_formal_clash(KeyP type_name,
                        TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00016 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[42].error, ET_00017, (GenericP)&closure);
}
void
E_c_unknown_param_assign(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[43].error, ET_00013, (GenericP)&closure);
}
void
E_c_param_assign_mult_def(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[44].error, ET_00013, (GenericP)&closure);
}
void
E_c_param_assign_param_clash(KeyP type_name,
                             TypeTupleP parameter_type)
{
    struct ES_00013 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[45].error, ET_00014, (GenericP)&closure);
}
void
E_c_param_assign_param_mismatch(KeyP type_name,
                                TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[46].error, ET_00015, (GenericP)&closure);
}
void
E_c_param_assign_result_clash(KeyP type_name,
                              TypeTupleP result_type)
{
    struct ES_00015 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[47].error, ET_00016, (GenericP)&closure);
}
void
E_c_param_assign_res_mismatch(KeyP type_name,
                              TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[48].error, ET_00015, (GenericP)&closure);
}
void
E_c_param_assign_formal_clash(KeyP type_name,
                              TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00016 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[49].error, ET_00017, (GenericP)&closure);
}
void
E_c_unknown_result_assign(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[50].error, ET_00013, (GenericP)&closure);
}
void
E_c_result_assign_mult_def(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[51].error, ET_00013, (GenericP)&closure);
}
void
E_c_result_assign_param_clash(KeyP type_name,
                              TypeTupleP parameter_type)
{
    struct ES_00013 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[52].error, ET_00014, (GenericP)&closure);
}
void
E_c_res_assign_param_mismatch(KeyP type_name,
                              TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[53].error, ET_00015, (GenericP)&closure);
}
void
E_c_result_assign_result_clash(KeyP type_name,
                               TypeTupleP result_type)
{
    struct ES_00015 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[54].error, ET_00016, (GenericP)&closure);
}
void
E_c_res_assign_result_mismatch(KeyP type_name,
                               TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00014 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[55].error, ET_00015, (GenericP)&closure);
}
void
E_c_result_assign_formal_clash(KeyP type_name,
                               TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00016 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.type_name = type_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[56].error, ET_00017, (GenericP)&closure);
}
void
E_c_unknown_action(NStringP action_name)
{
    struct ES_00017 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    error_call_init_proc();
    error_report(EE[57].error, ET_00018, (GenericP)&closure);
}
void
E_c_action_mult_def(NStringP action_name)
{
    struct ES_00017 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    error_call_init_proc();
    error_report(EE[58].error, ET_00018, (GenericP)&closure);
}
void
E_c_action_param_clash(KeyP action_name,
                       TypeTupleP parameter_type)
{
    struct ES_00018 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[59].error, ET_00019, (GenericP)&closure);
}
void
E_c_action_param_mismatch(KeyP action_name,
                          TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[60].error, ET_00020, (GenericP)&closure);
}
void
E_c_action_result_clash(KeyP action_name,
                        TypeTupleP result_type)
{
    struct ES_00020 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[61].error, ET_00021, (GenericP)&closure);
}
void
E_c_action_result_mismatch(KeyP action_name,
                           TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[62].error, ET_00020, (GenericP)&closure);
}
void
E_c_action_formal_clash(KeyP action_name,
                        TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00021 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.action_name = action_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[63].error, ET_00022, (GenericP)&closure);
}
void
E_c_unknown_basic(NStringP terminal_name)
{
    struct ES_00022 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    error_call_init_proc();
    error_report(EE[64].error, ET_00023, (GenericP)&closure);
}
void
E_c_basic_mult_def(NStringP terminal_name)
{
    struct ES_00022 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    error_call_init_proc();
    error_report(EE[65].error, ET_00023, (GenericP)&closure);
}
void
E_c_basic_param_clash(KeyP terminal_name,
                      TypeTupleP parameter_type)
{
    struct ES_00023 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[66].error, ET_00024, (GenericP)&closure);
}
void
E_c_basic_param_mismatch(KeyP terminal_name,
                         TypeTupleP erroneous_type)
{
    struct ES_00024 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[67].error, ET_00025, (GenericP)&closure);
}
void
E_c_basic_result_clash(KeyP terminal_name,
                       TypeTupleP result_type)
{
    struct ES_00025 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[68].error, ET_00026, (GenericP)&closure);
}
void
E_c_basic_result_mismatch(KeyP terminal_name,
                          TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00026 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[69].error, ET_00027, (GenericP)&closure);
}
void
E_c_basic_formal_clash(KeyP terminal_name,
                       TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00027 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[70].error, ET_00028, (GenericP)&closure);
}
void
E_c_basic_has_no_result(NStringP terminal_name)
{
    struct ES_00022 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    closure.terminal_name = terminal_name;
    error_call_init_proc();
    error_report(EE[71].error, ET_00023, (GenericP)&closure);
}
void
E_c_expected_identifier(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[72].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_c_identifier(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[73].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_separator(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[74].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_open_tuple(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[75].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_close_tuple(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[76].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_arrow(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[77].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_terminator(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[78].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_end_action(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[79].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_define(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[80].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_code(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[81].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_blt_header(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[82].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_blt_terminals(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[83].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_blt_actions(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[84].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_blt_trailer(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[85].error, ET_00006, (GenericP)&closure);
}
void
E_c_expected_eof(void)
{
    struct ES_00006 closure;

	    closure.file_name = c_lexer_stream_name(c_current_stream);
	    closure.line_number = c_lexer_stream_line(c_current_stream);
    error_call_init_proc();
    error_report(EE[86].error, ET_00006, (GenericP)&closure);
}
void
E_errf_null_char_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[87].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_null_character_in_name(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[88].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_null_character_in_string(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[89].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_newline_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[90].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_newline_in_name(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[91].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_newline_in_string(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[92].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_eof_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[93].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_eof_in_name(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[94].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_eof_in_string(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[95].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_illegal_esc_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[96].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_illegal_escape_in_name(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[97].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_illegal_escape_in_string(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[98].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_unknown_builtin(IStreamP istream,
                       CStringP builtin_name)
{
    struct ES_00028 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.builtin_name = builtin_name;
    error_call_init_proc();
    error_report(EE[99].error, ET_00029, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_illegal_character(IStreamP istream,
                         char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[100].error, ET_00007, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_expected_string(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[101].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_expected_section(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[102].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_unknown_string(IStreamP istream,
                      CStringP string_name)
{
    struct ES_00029 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.string_name = string_name;
    error_call_init_proc();
    error_report(EE[103].error, ET_00030, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_unknown_error(IStreamP istream,
                     CStringP error_name)
{
    struct ES_00030 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.error_name = error_name;
    error_call_init_proc();
    error_report(EE[104].error, ET_00031, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_illegal_message(IStreamP istream,
                       CStringP message)
{
    struct ES_00031 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.message = message;
    error_call_init_proc();
    error_report(EE[105].error, ET_00032, (GenericP)&closure);
    UNREACHED;
}
void
E_errf_cannot_open(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[106].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_exception_unhandled(ExceptionP except_name,
                      CStringP file_name, unsigned line_number)
{
    struct ES_00033 closure;

    closure.except_name = except_name;
    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[107].error, ET_00034, (GenericP)&closure);
    UNREACHED;
}
void
E_exception_corrupt_handler(CStringP file_name,
                            unsigned line_number)
{
    struct ES_00006 closure;

    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[108].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_assertion_failed(CStringP assertion,
                   CStringP file_name, unsigned line_number)
{
    struct ES_00034 closure;

    closure.assertion = assertion;
    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[109].error, ET_00035, (GenericP)&closure);
    UNREACHED;
}
void
E_dalloc_multi_deallocate(GenericP block_address,
                          CStringP file_name, unsigned line_number, CStringP allocation_file_name, unsigned allocation_line_number)
{
    struct ES_00035 closure;

    closure.block_address = block_address;
    closure.file_name = file_name;
    closure.line_number = line_number;
    closure.allocation_file_name = allocation_file_name;
    closure.allocation_line_number = allocation_line_number;
    error_call_init_proc();
    error_report(EE[110].error, ET_00036, (GenericP)&closure);
    UNREACHED;
}
void
E_dalloc_corrupt_block(GenericP block_address,
                       CStringP file_name, unsigned line_number)
{
    struct ES_00036 closure;

    closure.block_address = block_address;
    closure.file_name = file_name;
    closure.line_number = line_number;
    error_call_init_proc();
    error_report(EE[111].error, ET_00037, (GenericP)&closure);
    UNREACHED;
}
void
E_rule_not_used(KeyP rule_name)
{
    struct ES_00037 closure;

    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[112].error, ET_00038, (GenericP)&closure);
}
void
E_basic_not_used(KeyP basic_name)
{
    struct ES_00002 closure;

    closure.basic_name = basic_name;
    error_call_init_proc();
    error_report(EE[113].error, ET_00002, (GenericP)&closure);
}
void
E_action_not_used(KeyP action_name)
{
    struct ES_00003 closure;

    closure.action_name = action_name;
    error_call_init_proc();
    error_report(EE[114].error, ET_00003, (GenericP)&closure);
}
void
E_type_not_used(KeyP type_name)
{
    struct ES_00004 closure;

    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[115].error, ET_00004, (GenericP)&closure);
}
void
E_non_local_not_used(KeyP non_local_name_name)
{
    struct ES_00038 closure;

    closure.non_local_name_name = non_local_name_name;
    error_call_init_proc();
    error_report(EE[116].error, ET_00039, (GenericP)&closure);
}
void
E_rule_not_defined(KeyP rule_name)
{
    struct ES_00037 closure;

    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[117].error, ET_00038, (GenericP)&closure);
}
void
E_too_many_terminals(void)
{
    error_call_init_proc();
    error_report(EE[118].error, ET_00040, NIL(GenericP));
    UNREACHED;
}
void
E_illegal_character(IStreamP istream,
                    char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[119].error, ET_00007, (GenericP)&closure);
}
void
E_illegal_comment_character(IStreamP istream,
                            char character)
{
    struct ES_00007 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.character = character;
    error_call_init_proc();
    error_report(EE[120].error, ET_00007, (GenericP)&closure);
}
void
E_eof_in_comment(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[121].error, ET_00006, (GenericP)&closure);
}
void
E_unknown_builtin(IStreamP istream,
                  CStringP builtin)
{
    struct ES_00008 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    closure.builtin = builtin;
    error_call_init_proc();
    error_report(EE[122].error, ET_00008, (GenericP)&closure);
    UNREACHED;
}
void
E_null_character_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[123].error, ET_00006, (GenericP)&closure);
}
void
E_eof_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[124].error, ET_00006, (GenericP)&closure);
}
void
E_newline_in_builtin(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[125].error, ET_00006, (GenericP)&closure);
}
void
E_expected_hash(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[126].error, ET_00006, (GenericP)&closure);
}
void
E_expected_pipe(IStreamP istream)
{
    struct ES_00006 closure;

	    closure.file_name = istream_name(istream);
	    closure.line_number = istream_line(istream);
    error_call_init_proc();
    error_report(EE[127].error, ET_00006, (GenericP)&closure);
}
void
E_bad_tab_width(CStringP tab_width)
{
    struct ES_00039 closure;

    closure.tab_width = tab_width;
    error_call_init_proc();
    error_report(EE[128].error, ET_00041, (GenericP)&closure);
    UNREACHED;
}
void
E_bad_factor_limit(CStringP factor_limit)
{
    struct ES_00040 closure;

    closure.factor_limit = factor_limit;
    error_call_init_proc();
    error_report(EE[129].error, ET_00042, (GenericP)&closure);
    UNREACHED;
}
void
E_bad_inlining_phase(CStringP phase)
{
    struct ES_00041 closure;

    closure.phase = phase;
    error_call_init_proc();
    error_report(EE[130].error, ET_00043, (GenericP)&closure);
    UNREACHED;
}
void
E_bad_language(CStringP language_name)
{
    struct ES_00042 closure;

    closure.language_name = language_name;
    error_call_init_proc();
    error_report(EE[131].error, ET_00044, (GenericP)&closure);
    UNREACHED;
}
void
E_bad_language_option(CStringP language_name,
                      CStringP option)
{
    struct ES_00043 closure;

    closure.language_name = language_name;
    closure.option = option;
    error_call_init_proc();
    error_report(EE[132].error, ET_00045, (GenericP)&closure);
    UNREACHED;
}
void
E_bad_split_size(CStringP split_size)
{
    struct ES_00044 closure;

    closure.split_size = split_size;
    error_call_init_proc();
    error_report(EE[133].error, ET_00046, (GenericP)&closure);
    UNREACHED;
}
void
E_usage(CStringP language_name,
        unsigned number_input_files,
        unsigned number_output_files, ArgUsageP usage)
{
    struct ES_00045 closure;

    closure.language_name = language_name;
    closure.number_input_files = number_input_files;
    closure.number_output_files = number_output_files;
    closure.usage = usage;
    error_call_init_proc();
    error_report(EE[134].error, ET_00047, (GenericP)&closure);
    UNREACHED;
}
void
E_cannot_open_dump_file(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[135].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_multiple_dump_files(void)
{
    error_call_init_proc();
    error_report(EE[136].error, ET_00040, NIL(GenericP));
    UNREACHED;
}
void
E_cannot_open_output_file(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[137].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_cannot_open_input_file(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[138].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_no_memory(void)
{
    error_call_init_proc();
    error_report(EE[139].error, ET_00040, NIL(GenericP));
    UNREACHED;
}
void
E_read_error(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[140].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_write_error(CStringP file_name)
{
    struct ES_00032 closure;

    closure.file_name = file_name;
    error_call_init_proc();
    error_report(EE[141].error, ET_00033, (GenericP)&closure);
    UNREACHED;
}
void
E_expected_basic(CStringP class_name)
{
    struct ES_00009 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.class_name = class_name;
    error_call_init_proc();
    error_report(EE[142].error, ET_00010, (GenericP)&closure);
    UNREACHED;
}
void
E_expected_non_terminal(CStringP class_name)
{
    struct ES_00009 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.class_name = class_name;
    error_call_init_proc();
    error_report(EE[143].error, ET_00010, (GenericP)&closure);
    UNREACHED;
}
void
E_duplicate_action(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[144].error, ET_00012, (GenericP)&closure);
}
void
E_duplicate_basic(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[145].error, ET_00012, (GenericP)&closure);
}
void
E_duplicate_rule(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[146].error, ET_00012, (GenericP)&closure);
}
void
E_duplicate_type(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[147].error, ET_00012, (GenericP)&closure);
}
void
E_duplicate_non_local(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[148].error, ET_00012, (GenericP)&closure);
}
void
E_unknown_action(NStringP action_name)
{
    struct ES_00017 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    error_call_init_proc();
    error_report(EE[149].error, ET_00018, (GenericP)&closure);
}
void
E_unknown_rule(NStringP rule_name)
{
    struct ES_00046 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[150].error, ET_00048, (GenericP)&closure);
}
void
E_unknown_type(NStringP type_name)
{
    struct ES_00012 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.type_name = type_name;
    error_call_init_proc();
    error_report(EE[151].error, ET_00013, (GenericP)&closure);
}
void
E_unknown_rule_or_basic(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[152].error, ET_00012, (GenericP)&closure);
}
void
E_identity_mismatch(TypeTupleP correct_type,
                    TypeTupleP erroneous_type)
{
    struct ES_00047 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[153].error, ET_00049, (GenericP)&closure);
}
void
E_initialiser_result_mismatch(KeyP name_name,
                              TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00048 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[154].error, ET_00050, (GenericP)&closure);
}
void
E_action_result_call_mismatch(KeyP action_name,
                              TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[155].error, ET_00020, (GenericP)&closure);
}
void
E_basic_result_call_mismatch(KeyP terminal_name,
                             TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00026 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[156].error, ET_00027, (GenericP)&closure);
}
void
E_rule_result_call_mismatch(KeyP rule_name,
                            TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00049 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[157].error, ET_00051, (GenericP)&closure);
}
void
E_initialiser_param_mismatch(KeyP name_name,
                             TypeTupleP correct_type, TypeTupleP correct_ref_type, TypeTupleP erroneous_type)
{
    struct ES_00050 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    closure.correct_type = correct_type;
    closure.correct_ref_type = correct_ref_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[158].error, ET_00052, (GenericP)&closure);
}
void
E_action_param_call_mismatch(KeyP action_name,
                             TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[159].error, ET_00020, (GenericP)&closure);
}
void
E_basic_param_call_mismatch(KeyP terminal_name,
                            TypeTupleP erroneous_type)
{
    struct ES_00024 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[160].error, ET_00025, (GenericP)&closure);
}
void
E_basic_param_mismatch(KeyP terminal_name,
                       TypeTupleP erroneous_type)
{
    struct ES_00024 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[161].error, ET_00025, (GenericP)&closure);
}
void
E_rule_param_call_mismatch(KeyP rule_name,
                           TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00049 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[162].error, ET_00051, (GenericP)&closure);
}
void
E_rule_param_mismatch(KeyP rule_name,
                      TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00049 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[163].error, ET_00051, (GenericP)&closure);
}
void
E_rule_result_mismatch(KeyP rule_name,
                       TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00049 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[164].error, ET_00051, (GenericP)&closure);
}
void
E_action_param_mismatch(KeyP action_name,
                        TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[165].error, ET_00020, (GenericP)&closure);
}
void
E_action_result_mismatch(KeyP action_name,
                         TypeTupleP correct_type, TypeTupleP erroneous_type)
{
    struct ES_00019 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[166].error, ET_00020, (GenericP)&closure);
}
void
E_alt_result_mismatch(KeyP rule_name,
                      unsigned alternative)
{
    struct ES_00051 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.alternative = alternative;
    error_call_init_proc();
    error_report(EE[167].error, ET_00053, (GenericP)&closure);
}
void
E_handler_result_mismatch(KeyP rule_name)
{
    struct ES_00052 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[168].error, ET_00054, (GenericP)&closure);
}
void
E_multi_predicate_return(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[169].error, ET_00006, (GenericP)&closure);
}
void
E_predicate_type(EntryP correct_type,
                 EntryP erroneous_type)
{
    struct ES_00053 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.correct_type = correct_type;
    closure.erroneous_type = erroneous_type;
    error_call_init_proc();
    error_report(EE[170].error, ET_00055, (GenericP)&closure);
}
void
E_predicate(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[171].error, ET_00006, (GenericP)&closure);
}
void
E_undefined_assignment(NStringP name_name)
{
    struct ES_00054 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    error_call_init_proc();
    error_report(EE[172].error, ET_00056, (GenericP)&closure);
}
void
E_rule_already_defined(KeyP rule_name)
{
    struct ES_00052 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[173].error, ET_00054, (GenericP)&closure);
}
void
E_rule_formal_clash(KeyP rule_name,
                    TypeTupleP parameter_type, TypeTupleP result_type)
{
    struct ES_00055 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.parameter_type = parameter_type;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[174].error, ET_00057, (GenericP)&closure);
}
void
E_rule_param_clash(KeyP rule_name,
                   TypeTupleP parameter_type)
{
    struct ES_00056 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[175].error, ET_00058, (GenericP)&closure);
}
void
E_rule_result_clash(KeyP rule_name,
                    TypeTupleP result_type)
{
    struct ES_00057 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[176].error, ET_00059, (GenericP)&closure);
}
void
E_identity_result_clash(TypeTupleP result_type)
{
    struct ES_00058 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[177].error, ET_00060, (GenericP)&closure);
}
void
E_action_result_call_clash(KeyP action_name,
                           TypeTupleP result_type)
{
    struct ES_00020 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[178].error, ET_00021, (GenericP)&closure);
}
void
E_basic_result_call_clash(KeyP terminal_name,
                          TypeTupleP result_type)
{
    struct ES_00025 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[179].error, ET_00026, (GenericP)&closure);
}
void
E_rule_result_call_clash(KeyP rule_name,
                         TypeTupleP result_type)
{
    struct ES_00057 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[180].error, ET_00059, (GenericP)&closure);
}
void
E_undefined_name(KeyP identifier_name,
                 KeyP rule_name,
                 unsigned alternative)
{
    struct ES_00059 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    closure.rule_name = rule_name;
    closure.alternative = alternative;
    error_call_init_proc();
    error_report(EE[181].error, ET_00061, (GenericP)&closure);
}
void
E_redefined_name(KeyP identifier_name,
                 KeyP rule_name,
                 unsigned alternative)
{
    struct ES_00059 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    closure.rule_name = rule_name;
    closure.alternative = alternative;
    error_call_init_proc();
    error_report(EE[182].error, ET_00061, (GenericP)&closure);
}
void
E_multiple_empty_alts(KeyP rule_name)
{
    struct ES_00052 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[183].error, ET_00054, (GenericP)&closure);
}
void
E_too_many_alternatives(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[184].error, ET_00006, (GenericP)&closure);
    UNREACHED;
}
void
E_mult_entry(KeyP rule_name)
{
    struct ES_00052 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[185].error, ET_00054, (GenericP)&closure);
}
void
E_rule_param_has_names(KeyP rule_name,
                       TypeTupleP parameter_type)
{
    struct ES_00056 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[186].error, ET_00058, (GenericP)&closure);
}
void
E_rule_result_has_names(KeyP rule_name,
                        TypeTupleP result_type)
{
    struct ES_00057 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[187].error, ET_00059, (GenericP)&closure);
}
void
E_rule_result_has_refs(KeyP rule_name,
                       TypeTupleP result_type)
{
    struct ES_00057 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.rule_name = rule_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[188].error, ET_00059, (GenericP)&closure);
}
void
E_action_param_has_names(KeyP action_name,
                         TypeTupleP parameter_type)
{
    struct ES_00018 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[189].error, ET_00019, (GenericP)&closure);
}
void
E_action_result_has_names(KeyP action_name,
                          TypeTupleP result_type)
{
    struct ES_00020 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[190].error, ET_00021, (GenericP)&closure);
}
void
E_action_result_has_refs(KeyP action_name,
                         TypeTupleP result_type)
{
    struct ES_00020 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.action_name = action_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[191].error, ET_00021, (GenericP)&closure);
}
void
E_basic_param_has_names(KeyP terminal_name,
                        TypeTupleP parameter_type)
{
    struct ES_00023 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.parameter_type = parameter_type;
    error_call_init_proc();
    error_report(EE[192].error, ET_00024, (GenericP)&closure);
}
void
E_basic_result_has_names(KeyP terminal_name,
                         TypeTupleP result_type)
{
    struct ES_00025 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[193].error, ET_00026, (GenericP)&closure);
}
void
E_basic_result_has_refs(KeyP terminal_name,
                        TypeTupleP result_type)
{
    struct ES_00025 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    closure.result_type = result_type;
    error_call_init_proc();
    error_report(EE[194].error, ET_00026, (GenericP)&closure);
}
void
E_identity_param_has_refs(TypeTupleP parameter_type,
                          KeyP rule_name, unsigned alternative)
{
    struct ES_00060 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.parameter_type = parameter_type;
    closure.rule_name = rule_name;
    closure.alternative = alternative;
    error_call_init_proc();
    error_report(EE[195].error, ET_00062, (GenericP)&closure);
}
void
E_ignored_basic_call(NStringP terminal_name)
{
    struct ES_00022 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.terminal_name = terminal_name;
    error_call_init_proc();
    error_report(EE[196].error, ET_00023, (GenericP)&closure);
}
void
E_ambiguous_call(NStringP identifier_name)
{
    struct ES_00011 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.identifier_name = identifier_name;
    error_call_init_proc();
    error_report(EE[197].error, ET_00012, (GenericP)&closure);
}
void
E_global_scope_non_local(NStringP name_name)
{
    struct ES_00054 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    error_call_init_proc();
    error_report(EE[198].error, ET_00056, (GenericP)&closure);
}
void
E_expected_typemark(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[199].error, ET_00006, (GenericP)&closure);
}
void
E_expected_identifier(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[200].error, ET_00006, (GenericP)&closure);
}
void
E_expected_tuple_defn(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[201].error, ET_00006, (GenericP)&closure);
}
void
E_expected_terminal_decn(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[202].error, ET_00006, (GenericP)&closure);
}
void
E_expected_separator(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[203].error, ET_00006, (GenericP)&closure);
}
void
E_expected_open_tuple(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[204].error, ET_00006, (GenericP)&closure);
}
void
E_expected_close_tuple(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[205].error, ET_00006, (GenericP)&closure);
}
void
E_expected_arrow(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[206].error, ET_00006, (GenericP)&closure);
}
void
E_expected_terminator(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[207].error, ET_00006, (GenericP)&closure);
}
void
E_expected_lhs_name(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[208].error, ET_00006, (GenericP)&closure);
}
void
E_expected_rhs_name(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[209].error, ET_00006, (GenericP)&closure);
}
void
E_expected_begin_action(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[210].error, ET_00006, (GenericP)&closure);
}
void
E_expected_end_action(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[211].error, ET_00006, (GenericP)&closure);
}
void
E_expected_end_scope(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[212].error, ET_00006, (GenericP)&closure);
}
void
E_expected_tuple_or_term(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[213].error, ET_00006, (GenericP)&closure);
}
void
E_expected_item_rhs(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[214].error, ET_00006, (GenericP)&closure);
}
void
E_expected_define(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[215].error, ET_00006, (GenericP)&closure);
}
void
E_expected_tuple_def_or_term(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[216].error, ET_00006, (GenericP)&closure);
}
void
E_expected_begin_rule(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[217].error, ET_00006, (GenericP)&closure);
}
void
E_expected_end_rule(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[218].error, ET_00006, (GenericP)&closure);
}
void
E_expected_item(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[219].error, ET_00006, (GenericP)&closure);
}
void
E_expected_alternative(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[220].error, ET_00006, (GenericP)&closure);
}
void
E_expected_other_defn(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[221].error, ET_00006, (GenericP)&closure);
}
void
E_expected_production_defn(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[222].error, ET_00006, (GenericP)&closure);
}
void
E_expected_blt_types(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[223].error, ET_00006, (GenericP)&closure);
}
void
E_expected_blt_terminals(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[224].error, ET_00006, (GenericP)&closure);
}
void
E_expected_blt_productions(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[225].error, ET_00006, (GenericP)&closure);
}
void
E_expected_blt_entry(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[226].error, ET_00006, (GenericP)&closure);
}
void
E_expected_eof(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[227].error, ET_00006, (GenericP)&closure);
}
void
E_expected_terminator_or_define(void)
{
    struct ES_00006 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    error_call_init_proc();
    error_report(EE[228].error, ET_00006, (GenericP)&closure);
}
void
E_first_set_collision(RuleP rule_name,
                      BasicClosureP terminal_names)
{
    struct ES_00061 closure;

    closure.rule_name = rule_name;
    closure.terminal_names = terminal_names;
    error_call_init_proc();
    error_report(EE[229].error, ET_00063, (GenericP)&closure);
}
void
E_predicate_collision(RuleP rule_name,
                      KeyP predicate_name)
{
    struct ES_00062 closure;

    closure.rule_name = rule_name;
    closure.predicate_name = predicate_name;
    error_call_init_proc();
    error_report(EE[230].error, ET_00064, (GenericP)&closure);
}
void
E_predicate_list_collision(RuleP rule_name,
                           EntryListP predicate_names)
{
    struct ES_00063 closure;

    closure.rule_name = rule_name;
    closure.predicate_names = predicate_names;
    error_call_init_proc();
    error_report(EE[231].error, ET_00065, (GenericP)&closure);
}
void
E_follow_set_collision(RuleP rule_name,
                       BasicClosureP terminal_names, ClashListP clashes)
{
    struct ES_00064 closure;

    closure.rule_name = rule_name;
    closure.terminal_names = terminal_names;
    closure.clashes = clashes;
    error_call_init_proc();
    error_report(EE[232].error, ET_00066, (GenericP)&closure);
}
void
E_predicate_follow_set_coll(RuleP rule_name,
                            EntryListP predicate_names, ClashListP clashes)
{
    struct ES_00065 closure;

    closure.rule_name = rule_name;
    closure.predicate_names = predicate_names;
    closure.clashes = clashes;
    error_call_init_proc();
    error_report(EE[233].error, ET_00067, (GenericP)&closure);
}
void
E_multiple_see_through_alts(RuleP rule_name)
{
    struct ES_00066 closure;

    closure.rule_name = rule_name;
    error_call_init_proc();
    error_report(EE[234].error, ET_00068, (GenericP)&closure);
}
void
E_too_many_factorisations(unsigned number_productions)
{
    struct ES_00067 closure;

    closure.number_productions = number_productions;
    error_call_init_proc();
    error_report(EE[235].error, ET_00069, (GenericP)&closure);
    UNREACHED;
}
void
E_factor_handler_mismatch(RuleP inner_rule_name,
                          RuleP outer_rule_name)
{
    struct ES_00068 closure;

    closure.inner_rule_name = inner_rule_name;
    closure.outer_rule_name = outer_rule_name;
    error_call_init_proc();
    error_report(EE[236].error, ET_00070, (GenericP)&closure);
}
void
E_factor_nl_entry(RuleP inner_rule_name,
                  RuleP outer_rule_name)
{
    struct ES_00068 closure;

    closure.inner_rule_name = inner_rule_name;
    closure.outer_rule_name = outer_rule_name;
    error_call_init_proc();
    error_report(EE[237].error, ET_00070, (GenericP)&closure);
}
void
E_cannot_compute_first_set(RuleP production)
{
    struct ES_00069 closure;

    closure.production = production;
    error_call_init_proc();
    error_report(EE[238].error, ET_00071, (GenericP)&closure);
}
void
E_see_to_predicate(KeyP predicate,
                   RuleP production)
{
    struct ES_00070 closure;

    closure.predicate = predicate;
    closure.production = production;
    error_call_init_proc();
    error_report(EE[239].error, ET_00072, (GenericP)&closure);
}
void
E_see_to_rule_predicate(RuleP inner_production,
                        RuleP outer_production)
{
    struct ES_00071 closure;

    closure.inner_production = inner_production;
    closure.outer_production = outer_production;
    error_call_init_proc();
    error_report(EE[240].error, ET_00073, (GenericP)&closure);
}
void
E_redundant_see_through_alt(RuleP production)
{
    struct ES_00069 closure;

    closure.production = production;
    error_call_init_proc();
    error_report(EE[241].error, ET_00074, (GenericP)&closure);
}
void
E_left_recursion_type_mismatch(RuleP productions)
{
    struct ES_00072 closure;

    closure.productions = productions;
    error_call_init_proc();
    error_report(EE[242].error, ET_00075, (GenericP)&closure);
}
void
E_left_rec_handler_mismatch(RuleP productions)
{
    struct ES_00072 closure;

    closure.productions = productions;
    error_call_init_proc();
    error_report(EE[243].error, ET_00075, (GenericP)&closure);
}
void
E_left_recursion_name_mismatch(RuleP productions)
{
    struct ES_00072 closure;

    closure.productions = productions;
    error_call_init_proc();
    error_report(EE[244].error, ET_00075, (GenericP)&closure);
}
void
E_out_of_scope_non_local(RuleP using_production,
                         RuleP out_of_scope_production, RuleP productions)
{
    struct ES_00073 closure;

    closure.using_production = using_production;
    closure.out_of_scope_production = out_of_scope_production;
    closure.productions = productions;
    error_call_init_proc();
    error_report(EE[245].error, ET_00076, (GenericP)&closure);
}
void
E_left_recursion_nl_entry(RuleP production,
                          RuleP productions)
{
    struct ES_00074 closure;

    closure.production = production;
    closure.productions = productions;
    error_call_init_proc();
    error_report(EE[246].error, ET_00077, (GenericP)&closure);
}
void
E_cycle_no_terminator(RuleP rule_names)
{
    struct ES_00075 closure;

    closure.rule_names = rule_names;
    error_call_init_proc();
    error_report(EE[247].error, ET_00078, (GenericP)&closure);
}
void
E_shadows_non_local(KeyP name_name,
                    KeyP non_local_name_name, RuleP production)
{
    struct ES_00076 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    closure.non_local_name_name = non_local_name_name;
    closure.production = production;
    error_call_init_proc();
    error_report(EE[248].error, ET_00079, (GenericP)&closure);
}
void
E_shadows_global(KeyP name_name,
                 RuleP production)
{
    struct ES_00077 closure;

	    closure.file_name = lexer_stream_name(sid_current_stream);
	    closure.line_number = lexer_stream_line(sid_current_stream);
    closure.name_name = name_name;
    closure.production = production;
    error_call_init_proc();
    error_report(EE[249].error, ET_00080, (GenericP)&closure);
}
void
E_too_many_generated_ids(void)
{
    error_call_init_proc();
    error_report(EE[250].error, ET_00040, NIL(GenericP));
    UNREACHED;
}
void
E_too_many_generated_names(void)
{
    error_call_init_proc();
    error_report(EE[251].error, ET_00040, NIL(GenericP));
    UNREACHED;
}

void
gen_errors_init_errors(void)
{
    error_intern_tags (ET);
    error_intern_errors (EE);
}
