#!/usr/bin/env python
# Copyright (c) 2004 Eirik Nygaard <eirikn@kerneled.com>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the author nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

import vimlisp
import select
import os
import sys
import time
import pexpect
import re
import signal

# First we open the fifo
# This requires us to fork so we can open the fifo in both read and write mode,
# this is so it won't block.
try:
	childpid = os.fork()
except:
	print 'Unable to fork', sys.exc_info()[0]
	sys.exit()
# What do we want to open?
if childpid == 0:
	# Open fifo for writing
	try:
		fifofdchild = open(vimlisp.fifofile, 'w')
	except:
		print 'Unable to open fifo for writing', sys.exc_info()[0]
		sys.exit()
	fifofdchild.write('(format t "Vim+Lisp script is running.")\n')
	fifofdchild.close()
#	time.sleep(1)
	sys.exit()
else:
	# Let us open the fifo for reading
	try:
		fifofd = open(vimlisp.fifofile, 'r')
	except:
		print 'Unable to open fifo for reading', sys.exc_info()[0]
		sys.exit()

# Let us get the repl up and running!
replchild = pexpect.spawn (vimlisp.lisprepl)
while not replchild.isalive():
	time.sleep(1)
# We do not want to echo text we have written twice.
replchild.setecho(0);
debugerprompt = re.compile(vimlisp.debugprompt);

# Now, read from both fifo and stdin...
while 1:
	try:
		rready, wready, eready = select.select([sys.stdin, fifofd, replchild.fileno()], [], []);
	except KeyboardInterrupt:
		replchild.kill(signal.SIGINT)
		continue
	except:
		print 'Unable to preform select', sys.exc_info()[0]
		sys.exit()
	for fd in rready:
		if fd == replchild.fileno():
			str = ''
			while 1:
				try:
					ch = replchild.read_nonblocking(1, 1)
				except pexpect.EOF:
					print 'Repl is goooone!'
					sys.exit()
				except:
					print 'lisp REPL reading: ', sys.exc_info()[0]
					print 'lisp REPL reading: ', sys.exc_info()[1]
					sys.exit()
				if ch == '\r':
					# Do nothing for now
					str = str
				elif ch == '\n':
					str = str + ch;
					break;
				else:
					str = str + ch;
				if str == vimlisp.replprompt:
					break;
				if debugerprompt.match(str) != None:
					break;
				sys.stdout.flush()
			print str,
			sys.stdout.flush()
		else:
			line = fd.readline()
			replchild.send(line)
	if not replchild.isalive():
		print 'The repl is gone...\nShutting down...\n'
		sys.exit()
	
	# Wait for the child so it is not stuck in a zombie state when done.
	if childpid:
		childpidstatus, thing = os.waitpid(childpid, os.WNOHANG)
		if childpidstatus == childpid:
			childpid = 0



