#--------------------------------------------------
# digidoc.conf
# DigiDoc library global configuration file
#--------------------------------------------------

CA_CERT_PATH=@DIGIDOC_CERTS_PATH@
CA_CERTS=7
CA_CERT_1=sk-root.pem
CA_CERT_1_CN=Juur-SK
CA_CERT_2=sk-esteid.pem
CA_CERT_2_CN=ESTEID-SK
CA_CERT_3=sk-test.pem
CA_CERT_3_CN=TEST-SK
CA_CERT_4=sk-klass3.pem
CA_CERT_4_CN=KLASS3-SK
CA_CERT_5=eid-sk.pem
CA_CERT_5_CN=EID-SK
CA_CERT_6=esteid-sk-2007.pem
CA_CERT_6_CN=ESTEID-SK 2007
CA_CERT_7=eid-sk-2007.pem
CA_CERT_7_CN=EID-SK 2007


DIGIDOC_FORMAT=DIGIDOC-XML
DIGIDOC_VERSION=1.3

DIGIDOC_DEFAULT_DRIVER=1
DIGIDOC_DRIVERS=1
DIGIDOC_DRIVER_1_NAME=OpenSC
DIGIDOC_DRIVER_1_DESC=OpenSC projects PKCS#11 driver
DIGIDOC_DRIVER_1_FILE=@PKCS11_MODULE@
DIGIDOC_SIGNATURE_SLOT=1

SIGN_OCSP=0
USE_PROXY=0

# open ip 91.198.206.66
DIGIDOC_OCSP_RESPONDER_CERTS=9
DIGIDOC_OCSP_RESPONDER_CERT_1=sk-esteid-ocsp-responder.pem
DIGIDOC_OCSP_RESPONDER_CERT_1_CN=ESTEID-SK OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_1_CA=ESTEID-SK
DIGIDOC_OCSP_RESPONDER_CERT_1_URL=http://ocsp.sk.ee
DIGIDOC_OCSP_RESPONDER_CERT_2=sk-test-ocsp-responder.pem
DIGIDOC_OCSP_RESPONDER_CERT_2_1=test_ocsp_020305-040305.pem
DIGIDOC_OCSP_RESPONDER_CERT_2_2=test_ocsp_040305-080308.pem
DIGIDOC_OCSP_RESPONDER_CERT_2_CN=TEST-SK OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_2_CA=TEST-SK
DIGIDOC_OCSP_RESPONDER_CERT_2_URL=http://www.openxades.org/cgi-bin/ocsp.cgi
DIGIDOC_OCSP_RESPONDER_CERT_3=sk-klass3-ocsp-responder-2009.cer
DIGIDOC_OCSP_RESPONDER_CERT_3_1=sk-klass3-ocsp-responder.pem
DIGIDOC_OCSP_RESPONDER_CERT_3_2=sk-klass3-ocsp-responder-2006.cer
DIGIDOC_OCSP_RESPONDER_CERT_3_CN=KLASS3-SK OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_3_CA=KLASS3-SK
DIGIDOC_OCSP_RESPONDER_CERT_3_URL=http://ocsp.sk.ee
DIGIDOC_OCSP_RESPONDER_CERT_4=sk-eid-ocsp-responder-2006.cer
DIGIDOC_OCSP_RESPONDER_CERT_4_1=eid-sk_ocsp.pem
DIGIDOC_OCSP_RESPONDER_CERT_4_CN=EID-SK OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_4_CA=EID-SK
DIGIDOC_OCSP_RESPONDER_CERT_4_URL=http://ocsp.sk.ee
DIGIDOC_OCSP_RESPONDER_CERT_5=sk-test-ocsp-responder-2005.pem
DIGIDOC_OCSP_RESPONDER_CERT_5_1=test_ocsp_2006.cer
DIGIDOC_OCSP_RESPONDER_CERT_5_CN=TEST-SK OCSP RESPONDER 2005
DIGIDOC_OCSP_RESPONDER_CERT_5_CA=TEST-SK
DIGIDOC_OCSP_RESPONDER_CERT_5_URL=http://www.openxades.org/cgi-bin/ocsp.cgi
DIGIDOC_OCSP_RESPONDER_CERT_6=sk-esteid-ocsp-responder-2005.pem
DIGIDOC_OCSP_RESPONDER_CERT_6_CN=ESTEID-SK OCSP RESPONDER 2005
DIGIDOC_OCSP_RESPONDER_CERT_6_CA=ESTEID-SK
DIGIDOC_OCSP_RESPONDER_CERT_6_URL=http://ocsp.sk.ee
DIGIDOC_OCSP_RESPONDER_CERT_7=ocsp_hash_resp1.pem
DIGIDOC_OCSP_RESPONDER_CERT_7_CN=TEST-SK OCSP RESPONDER 2005
DIGIDOC_OCSP_RESPONDER_CERT_7_CA=TEST-SK
DIGIDOC_OCSP_RESPONDER_CERT_7_HASH=wQTlchxigvxduKbKNDQUqx9k2Sk=
DIGIDOC_OCSP_RESPONDER_CERT_7_URL=http://www.openxades.org/cgi-bin/ocsp.cgi
DIGIDOC_OCSP_RESPONDER_CERT_8=esteid-sk-2007-responder.pem
DIGIDOC_OCSP_RESPONDER_CERT_8_CN=ESTEID-SK 2007 OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_8_CA=ESTEID-SK 2007
DIGIDOC_OCSP_RESPONDER_CERT_8_URL=http://ocsp.sk.ee
DIGIDOC_OCSP_RESPONDER_CERT_9=eid-sk-2007-responder.pem
DIGIDOC_OCSP_RESPONDER_CERT_9_CN=EID-SK 2007 OCSP RESPONDER
DIGIDOC_OCSP_RESPONDER_CERT_9_CA=EID-SK 2007
DIGIDOC_OCSP_RESPONDER_CERT_9_URL=http://ocsp.sk.ee

#DIGIDOC_OCSP_URL=http://www.openxades.org/cgi-bin/ocsp.cgi
DIGIDOC_OCSP_URL=http://ocsp.sk.ee
#DIGIDOC_OCSP_URL=http://www.sk.ee:9080/cgi-bin/ocsp.cgi

# TSA settings
#TSA_POLICY=
TSA_URL=http://ns.szikszi.hu:8080/tsa
TSA_CERT=tsa_ns.crt
TSA_CA_CERT=ts_cacert.crt


#MSSP settings
#DIGIDOC_MSSP_ENDPOINT=https://www.pilet.ee:8091/MSSP_GW
DIGIDOC_MSSP_ENDPOINT=https://linux.test.sk.sise:8091/MSSP_GW
#DIGIDOC_MSSP_GW_CERT=msspgw-cert.pem
DIGIDOC_MSSP_MAJOR=1
DIGIDOC_MSSP_MINOR=1
DIGIDOC_MSSP_MSG_MODE=1
DIGIDOC_MSSP_AP_USERID=digidoc
DIGIDOC_MSSP_AP_PASSWD=digidoc
DIGIDOC_MSSP_URL=http://www.sk.ee
DIGIDOC_MSSP_TIMEOUT=60
DIGIDOC_MSSP_MSG_MODE=asynchClientServer
DIGIDOC_MSSP_CERT_URL_HOST=http://localhost
DIGIDOC_MSSP_AUTH_CERT_DIR=/certs/wpki/sig/
DIGIDOC_MSSP_SIGN_CERT_DIR=/certs/wpki/auth/
