--- tcp_lat.c.orig	2013-08-26 15:57:45 UTC
+++ tcp_lat.c
@@ -117,11 +117,15 @@ init_parent(test_data *td)
   ts->buf = xmalloc(td->size);
   struct addrinfo *res = ts->info;
   int sockfd;
-  if ((sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) == -1)
-    err(1, "socket");
-    
-  while (connect(sockfd, res->ai_addr, res->ai_addrlen) == -1)
-    { }
+
+  for (;;) {
+    if ((sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) == -1)
+      err(1, "socket");
+    if (connect(sockfd, res->ai_addr, res->ai_addrlen) == 0)
+      break;
+    /* Sockets suffering connect(2) failure could not be used anymore. */
+    close(sockfd);
+  }
 
 #ifdef USE_NODELAY
   int flag = 1;
