--- tcp_thr.c.orig	2013-08-26 15:57:45 UTC
+++ tcp_thr.c
@@ -159,11 +159,14 @@ init_parent(test_data *td)
 
   init_local(td, state);
 
-  if ((sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) == -1)
-    err(1, "socket");
-    
-  while (connect(sockfd, res->ai_addr, res->ai_addrlen) == -1)
-    { }
+  for (;;) {
+    if ((sockfd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) == -1)
+      err(1, "socket");
+    if (connect(sockfd, res->ai_addr, res->ai_addrlen) == 0)
+      break;
+    /* Sockets suffering connect(2) failure could not be used anymore. */
+    close(sockfd);
+  }
 
 #ifdef USE_NODELAY
   int i = 1;
