/*
 * Intel ACPI Component Architecture
 * AML/ASL+ Disassembler version 20150930-64
 * Copyright (c) 2000 - 2015 Intel Corporation
 * 
 * Disassembling to symbolic ASL+ operators
 *
 * Disassembly of ssdt4.dat, Sat Oct 17 09:50:48 2015
 *
 * Original Table Header:
 *     Signature        "SSDT"
 *     Length           0x000003E6 (998)
 *     Revision         0x01
 *     Checksum         0x59
 *     OEM ID           "ACRSYS"
 *     OEM Table ID     "ACRPRDCT"
 *     OEM Revision     0x00001000 (4096)
 *     Compiler ID      "1025"
 *     Compiler Version 0x00040000 (262144)
 */
DefinitionBlock ("ssdt4.aml", "SSDT", 1, "ACRSYS", "ACRPRDCT", 0x00001000)
{

    External (_SB_.PCI0.GFX0.ASLC, UnknownObj)
    External (_SB_.PCI0.GFX0.ASLE, UnknownObj)
    External (_SB_.PCI0.GFX0.STAT, UnknownObj)
    External (_SB_.PCI0.GFX0.TCHE, UnknownObj)
    External (_SB_.PCI0.LPCB.H_EC.IPNC, IntObj)
    External (_SB_.PCI0.LPCB.H_EC.LSTE, IntObj)
    External (_SB_.PCI0.LPCB.H_EC.RPWR, UnknownObj)
    External (_SB_.PCI0.LPCB.H_EC.S0IS, IntObj)
    External (_SB_.PCI0.LPCB.H_EC.S3T0, UnknownObj)
    External (_SB_.PCI0.LPCB.H_EC.S3T1, UnknownObj)
    External (_SB_.PCI0.LPCB.H_EC.S3T2, UnknownObj)
    External (_SB_.PCI0.LPCB.H_EC.S3WR, UnknownObj)
    External (ICNF, IntObj)

    Scope (\_SB)
    {
        Device (IAOE)
        {
            OperationRegion (ISCT, SystemMemory, 0x785D0F98, 0x0028)
            Field (ISCT, AnyAcc, Lock, Preserve)
            {
                WKRS,   8, 
                AOCE,   8
            }

            Name (_HID, "INT33A0" /* Intel Smart Connect Technology Device */)  // _HID: Hardware ID
            Name (_UID, Zero)  // _UID: Unique ID
            Name (INSB, Zero)
            Name (ABT0, Zero)
            Name (ABT1, Zero)
            Name (AWDT, Zero)
            Name (PTSL, Zero)
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (((AOCE & One) == One))
                {
                    Return (0x0F)
                }
                Else
                {
                    Return (Zero)
                }
            }

            Method (GABS, 0, NotSerialized)
            {
                Return (ICNF) /* External reference */
            }

            Method (GAOS, 0, NotSerialized)
            {
                Local0 = \_SB.PCI0.LPCB.H_EC.S0IS /* External reference */
                Local0 &= 0xFD
                Local0 |= ((\_SB.PCI0.LPCB.H_EC.RPWR & One) << One)
                Return (Local0)
            }

            Method (SAOS, 1, NotSerialized)
            {
                Local0 = (Zero | (Arg0 & 0x03))
                Local1 = \_SB.PCI0.LPCB.H_EC.S0IS /* External reference */
                If (((Local0 & One) != One))
                {
                    If ((Local1 & One))
                    {
                        If ((\_SB.PCI0.GFX0.TCHE & 0x0100))
                        {
                            \_SB.PCI0.GFX0.STAT &= 0xFFFFFFFC
                            \_SB.PCI0.GFX0.ASLC |= 0x0100
                            \_SB.PCI0.GFX0.ASLE = One
                        }
                    }
                }

                \_SB.PCI0.LPCB.H_EC.S0IS = Local0
            }

            Method (GANS, 0, NotSerialized)
            {
                Return (INSB) /* \_SB_.IAOE.INSB */
            }

            Method (SANS, 1, NotSerialized)
            {
                INSB = (Arg0 & One)
            }

            Method (GWLS, 0, NotSerialized)
            {
                Local1 = \_SB.PCI0.LPCB.H_EC.IPNC /* External reference */
                Local0 = (Zero | (Local1 & 0x0E))
                Return (Local0)
            }

            Method (SWLS, 1, NotSerialized)
            {
                Local0 = \_SB.PCI0.LPCB.H_EC.IPNC /* External reference */
                Local0 &= 0xF0
                Local0 |= (Arg0 & 0x0E)
                \_SB.PCI0.LPCB.H_EC.IPNC = Local0
            }

            Method (GWWS, 0, NotSerialized)
            {
                Local1 = \_SB.PCI0.LPCB.H_EC.IPNC /* External reference */
                Local1 >>= 0x03
                Local0 = (Zero | (Local1 & 0x0E))
                Return (Local0)
            }

            Method (SWWS, 1, NotSerialized)
            {
                Local0 = (Zero | (Arg0 & 0x0E))
                Local1 = \_SB.PCI0.LPCB.H_EC.IPNC /* External reference */
                Local1 &= 0x0E
                Local1 |= (Local0 << 0x03)
                \_SB.PCI0.LPCB.H_EC.IPNC = Local1
            }

            Method (SASD, 1, NotSerialized)
            {
                Local0 = Arg0
                If (((Local0 & 0x80000000) == One)) {}
                Else
                {
                    \_SB.PCI0.LPCB.H_EC.S3T0 = (Local0 & 0xFF)
                    \_SB.PCI0.LPCB.H_EC.S3T1 = ((Local0 & 0xFF00) >> 0x08)
                    \_SB.PCI0.LPCB.H_EC.S3T2 = ((Local0 & 0x00FF0000) >> 0x10)
                }
            }

            Method (GPWR, 0, NotSerialized)
            {
                Local0 = (\_SB.PCI0.LPCB.H_EC.S3WR & 0x03)
                Local1 = (WKRS & 0x0C)
                If ((Local1 & 0x0C))
                {
                    Return ((Local1 & 0x0C))
                }
                Else
                {
                    If ((Local0 & 0x03))
                    {
                        Return ((Local0 & 0x03))
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }
            }

            Method (GAWD, 0, NotSerialized)
            {
                Return (AWDT) /* \_SB_.IAOE.AWDT */
            }

            Method (SAWD, 1, NotSerialized)
            {
                AWDT = Arg0
            }

            Method (GPCS, 0, NotSerialized)
            {
                Local0 = \_SB.PCI0.LPCB.H_EC.LSTE /* External reference */
                Return (Local0)
            }
        }
    }
}

